/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.EmptyRepositoryNode;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryAttributeSetNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectSampleNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryPropertyNode;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.treeviews.ITreeViewListener;
import com.arcway.repository.interFace.data.IRepositoryDataItem;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceListener;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import java.util.ArrayList;

public class RepositoryTreeViewModelAccessAgent
implements ITreeViewModelAccessAgent {
    private final ListenerKey listenerKey = new ListenerKey();
    private final IRepositoryInterfaceListener repositoryInterfaceListener = new IRepositoryInterfaceListener(){

        public void dispose() {
            if (RepositoryTreeViewModelAccessAgent.this.treeViewListener != null) {
                RepositoryTreeViewModelAccessAgent.this.treeViewListener.treeViewIsShuttingDown((Object)RepositoryTreeViewModelAccessAgent.this.repositoryInterface);
            }
            if (RepositoryTreeViewModelAccessAgent.this.currentSnapshot != null) {
                RepositoryTreeViewModelAccessAgent.this.currentSnapshotID = null;
                RepositoryTreeViewModelAccessAgent.this.currentSnapshot = null;
            }
            RepositoryTreeViewModelAccessAgent.this.dispose();
        }

        public void repositoryNewCurrentSnapshot(IRepositoryObjectSample newCurrentSnapshotInformation) {
            try {
                IRepositoryObjectSample repositoryObjectSample = RepositoryTreeViewModelAccessAgent.this.repositoryInterface.sampleCurrentSnapshotInformation();
                IRepositoryPropertySetSample snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)repositoryObjectSample, (IRepositoryTypeManagerRO)RepositoryTreeViewModelAccessAgent.this.getRepositoryTypeManager());
                RepositoryTreeViewModelAccessAgent.this.openSnapshot(snapshotID);
            }
            catch (EXNotReproducibleSnapshot e) {
                logger.error((Throwable)e);
            }
            if (RepositoryTreeViewModelAccessAgent.this.treeViewListener != null) {
                RepositoryTreeViewModelAccessAgent.this.treeViewListener.treeViewChanged();
            }
        }

        public void repositorySnapshotListModified() {
        }
    };
    private final IRepositoryInterfaceRO repositoryInterface;
    private IRepositoryPropertySetSample currentSnapshotID;
    private IRepositorySnapshotRO currentSnapshot;
    private PresentationContext presentationContext;
    private final boolean multipleSnapshots;
    private long timeOfRefresh;
    private ITreeViewListener treeViewListener;
    private static final ILogger logger = Logger.getLogger(RepositoryTreeViewModelAccessAgent.class);

    public RepositoryTreeViewModelAccessAgent(IRepositoryInterfaceRO repositoryInterface) {
        this(repositoryInterface, false);
    }

    public RepositoryTreeViewModelAccessAgent(IRepositoryInterfaceRO repositoryInterface, boolean multipleSnapshots) {
        this.repositoryInterface = repositoryInterface;
        this.repositoryInterface.getListenerManager().addListener(this.listenerKey, (IDisposeListener)this.repositoryInterfaceListener);
        FrontendTypeManager.getFrontendTypeManager(repositoryInterface.getTypeManager()).getListenerManager().addListener(this.listenerKey, (IDisposeListener)this.repositoryInterfaceListener);
        this.presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        this.multipleSnapshots = multipleSnapshots;
        this.timeOfRefresh = Long.MAX_VALUE;
        try {
            IRepositoryObjectSample repositoryObjectSample = repositoryInterface.sampleCurrentSnapshotInformation();
            IRepositoryPropertySetSample snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)repositoryObjectSample, (IRepositoryTypeManagerRO)this.getRepositoryTypeManager());
            this.openSnapshot(snapshotID);
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error((Throwable)e);
        }
    }

    public Object getInvisibleRoot() {
        return this.repositoryInterface;
    }

    public boolean hasChildNodes(Object parentNode) {
        if (parentNode == this.repositoryInterface) {
            IList_ repositorySnapshotList = this.repositoryInterface.getAvailableSnapshotInformations();
            return !repositorySnapshotList.asJavaList().isEmpty();
        }
        if (parentNode instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)parentNode;
            try {
                return repositoryDataItem.hasChildNodes(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                return repositoryDataItem instanceof RepositoryObjectSampleNode;
            }
        }
        return false;
    }

    public Object[] getChildNodes(Object parentNode) {
        if (parentNode == this.repositoryInterface) {
            ArrayList<RepositoryObjectSampleNode> children = new ArrayList<RepositoryObjectSampleNode>();
            IList_ repositorySnapshotList = this.repositoryInterface.getAvailableSnapshotInformations();
            for (IRepositoryObjectSample repositoryObjectSample : repositorySnapshotList) {
                IRepositoryPropertySetSample snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)repositoryObjectSample, (IRepositoryTypeManagerRO)this.getRepositoryTypeManager());
                children.add(new RepositoryObjectSampleNode(repositoryObjectSample, this, snapshotID));
            }
            return children.toArray();
        }
        if (parentNode instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)parentNode;
            try {
                return repositoryDataItem.getChildNodes(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                Object[] childrenArray = new Object[]{new EmptyRepositoryNode(this, repositoryDataItem.getSnapshotID())};
                return childrenArray;
            }
        }
        return null;
    }

    public Object getParentNode(Object childNode) {
        if (childNode instanceof RepositoryObjectSampleNode) {
            return this.repositoryInterface;
        }
        if (childNode instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)childNode;
            try {
                return repositoryDataItem.getParentNode(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                return null;
            }
        }
        return null;
    }

    public PresentationContext getPresentationContext() {
        return this.presentationContext;
    }

    public void setPresentationContext(PresentationContext presentationContext) {
        this.presentationContext = presentationContext;
        this.timeOfRefresh = Long.MAX_VALUE;
    }

    public String getNodeText(Object node) {
        if (node instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)node;
            try {
                return repositoryDataItem.getNodeText(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                return "";
            }
        }
        return null;
    }

    public IStreamResource getNodeImage(Object node) {
        if (node instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)node;
            try {
                return repositoryDataItem.getNodeImage(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                return null;
            }
        }
        return null;
    }

    public boolean areEqualNodes(Object node1, Object node2) {
        return node1 != null && node1.equals(node2);
    }

    public int getHashCodeForNode(Object node) {
        return node.hashCode();
    }

    private IRepositorySnapshotRO openSnapshot(IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        if (!this.areEqualSnapshotIDs(snapshotID, this.currentSnapshotID)) {
            if (this.currentSnapshot != null) {
                this.currentSnapshot.closeSnapshot();
                this.currentSnapshotID = null;
                this.currentSnapshot = null;
            }
            this.currentSnapshot = this.repositoryInterface.openSnapshot(snapshotID);
            this.currentSnapshotID = snapshotID;
        }
        return this.currentSnapshot;
    }

    @Override
    public IRepositorySnapshotRO getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    @Override
    public IRepositoryPropertySetSample getCurrentSnapshotID() {
        return this.currentSnapshotID;
    }

    @Override
    public IRepositoryInterfaceRO getRepositoryInterface() {
        return this.repositoryInterface;
    }

    @Override
    public IRepositoryTypeManagerRO getRepositoryTypeManager() {
        return this.repositoryInterface.getTypeManager();
    }

    @Override
    public IFrontendTypeManager getFrontendTypeManager() {
        return FrontendTypeManager.getFrontendTypeManager(this.getRepositoryTypeManager());
    }

    @Override
    public void updateTimeOfRefresh(long newTime) {
        if (newTime < this.timeOfRefresh) {
            this.timeOfRefresh = newTime;
            if (this.treeViewListener != null) {
                this.treeViewListener.treeViewHasNewExparationTime(this.timeOfRefresh);
            }
        }
    }

    @Override
    public boolean areEqualRepositoryInterfaces(IRepositoryInterfaceRO interface1, IRepositoryInterfaceRO interface2) {
        if (interface1 == null || interface2 == null) {
            return false;
        }
        return RepositoryInterfaces.areRepositoryInterfaceReferencesEqual((Object)RepositoryInterfaces.getRepositoryInterfaceReference((IRepositoryInterfaceRO)interface1), (Object)RepositoryInterfaces.getRepositoryInterfaceReference((IRepositoryInterfaceRO)interface2));
    }

    @Override
    public boolean areEqualSnapshotIDs(IRepositoryPropertySetSample snapshotID1, IRepositoryPropertySetSample snapshotID2) {
        if (snapshotID1 == null || snapshotID2 == null) {
            return false;
        }
        return RepositorySamples.isEqual((IRepositoryPropertySetSample)snapshotID1, (IRepositoryPropertySetSample)snapshotID2);
    }

    public Object getItemForNode(Object node) {
        if (node instanceof RepositoryDataItemNode) {
            RepositoryDataItemNode repositoryDataItem = (RepositoryDataItemNode)node;
            try {
                return repositoryDataItem.getItem(this.currentSnapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                return null;
            }
        }
        return null;
    }

    public Object getNodeForItem(Object item) {
        IRepositoryPropertySetSample snapshotID;
        IRepositoryDataItem dataItem;
        IRepositorySnapshotRO snapshot;
        if (item instanceof IRepositoryDataItem && this.areEqualRepositoryInterfaces(this.repositoryInterface, (snapshot = (dataItem = (IRepositoryDataItem)item).getSnapshot()).getRepositoryInterface()) && this.areEqualSnapshotIDs(this.currentSnapshotID, snapshotID = RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshot.getSnapshotInformation(), (IRepositoryTypeManagerRO)this.getRepositoryTypeManager()))) {
            try {
                if (dataItem instanceof IRepositoryObject) {
                    return new RepositoryObjectNode((IRepositoryObject)dataItem, (ITreeViewModelAccessAgent)this, this.currentSnapshotID);
                }
                if (dataItem instanceof IRepositoryAttributeSet) {
                    return new RepositoryAttributeSetNode((IRepositoryAttributeSet)dataItem, this, this.currentSnapshotID);
                }
                if (dataItem instanceof IRepositoryProperty) {
                    return new RepositoryPropertyNode((IRepositoryProperty)dataItem, this, this.currentSnapshotID);
                }
            }
            catch (EXNotReproducibleSnapshot e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean checkSnapshotIDEquality() {
        return this.multipleSnapshots;
    }

    public void dispose() {
        FrontendTypeManager.getFrontendTypeManager(this.repositoryInterface.getTypeManager()).getListenerManager().removeListener(this.listenerKey);
        this.repositoryInterface.getListenerManager().removeListener(this.listenerKey);
        this.treeViewListener = null;
    }

    public void setupTreeViewListener(ITreeViewListener treeViewListener) {
        if (this.treeViewListener != null) {
            throw new IllegalArgumentException("setupTreeViewListener() was called twice");
        }
        this.treeViewListener = treeViewListener;
    }
}

