/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.imports.ImportJobEditorLayoutFactory;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.CurrentModelAndModificationsAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ImportJobAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ImportJobReferenceInterpreter;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.LockAndPermissionProvider;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.IImportEditorPropertyOrCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.frontend.definition.lib.ui.modificationproblems.RepositoryAccessModificationProblem;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.dialog.imports.ICompareModeChangeListener;
import com.arcway.lib.ui.dialog.imports.IImportModeChangeListener;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.dialog.imports.IModelChangeListener;
import com.arcway.lib.ui.editor.WidgetReference;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXRepositoryException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.lib.ui.modelaccess.ILayout;
import com.arcway.lib.ui.modelaccess.IModelAccessListener;
import com.arcway.lib.ui.modelaccess.agent.IModelChangeExecutionAgent;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.exceptions.RepositoryException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobChangeListener;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ModelAccess
implements IImportModelAccess<IImportEditorPropertyOrCategoryReference, ImportJobPropertyReference, ImportJobObjectTypeCategoryReference, IImportedObject> {
    private static final ILogger LOGGER = Logger.getLogger(ModelAccess.class);
    private int compare_mode = 1;
    private final IRepositoryTypeManagerRO repositoryTypeManager;
    private IRepositorySnapshotRO snapshotOrNullIfNotReproducible;
    private final EXNotReproducibleSnapshot exNotReproducibleSnapshot = null;
    private final Locale contentLocaleCache;
    private final CurrentModelAndModificationsAccessAgent currentModelAndModificationsAccessAgent;
    private final LockAndPermissionProvider lockAndPermissionProvider;
    private final ImportJobReferenceInterpreter contentReferenceInterpreter;
    private final ListenerManager<IModelChangeListener> modelChangeListeners = new ListenerManager();
    private final ListenerManager<ICompareModeChangeListener> compareModeChangeListeners = new ListenerManager();
    private final Map<IImportedObject, Tuple<Integer, ListenerManager<IImportModeChangeListener>>> importModeChangeListeners = new HashMap<IImportedObject, Tuple<Integer, ListenerManager<IImportModeChangeListener>>>();
    private final IImportJob importJob;
    private ListenerKey importJobChangeListenerKey;
    private boolean isDisposing = false;

    public ModelAccess(IImportJob importJob, IRepositorySnapshotRO repositorySnapshot) {
        this.importJob = importJob;
        this.snapshotOrNullIfNotReproducible = repositorySnapshot;
        this.repositoryTypeManager = repositorySnapshot.getTypeManager();
        IRepositoryInterfaceRO repositoryInterface = repositorySnapshot.getRepositoryInterface();
        this.contentLocaleCache = FrontendTypeManager.getFrontendTypeManager(this.repositoryTypeManager).getRepositoryLocale();
        this.contentReferenceInterpreter = new ImportJobReferenceInterpreter(repositoryInterface);
        ImportJobAccessAgent importJobAccessAgent = new ImportJobAccessAgent(repositorySnapshot, importJob, this.contentReferenceInterpreter);
        this.currentModelAndModificationsAccessAgent = new CurrentModelAndModificationsAccessAgent(repositoryInterface, this, importJobAccessAgent);
        this.lockAndPermissionProvider = new LockAndPermissionProvider(repositoryInterface, this);
        this.importJobChangeListenerKey = new ListenerKey();
        importJob.addChangeListener(this.importJobChangeListenerKey, new IImportJobChangeListener(){

            public void dispose() {
                ModelAccess.this.removeImportJobChangeListener();
            }

            public void importJobChanged() throws EXNotReproducibleSnapshot {
                ModelAccess.this.modelChangeListeners.callListeners((IListenerCaller)new IListenerCaller<IModelChangeListener>(){

                    public void callListener(IModelChangeListener listener) {
                        listener.modelChanged();
                    }
                });
                ArrayList<IImportedObject> changedObjects = new ArrayList<IImportedObject>();
                for (Map.Entry entry : ModelAccess.this.importModeChangeListeners.entrySet()) {
                    int newImportMode;
                    IImportedObject importedObject = (IImportedObject)entry.getKey();
                    Tuple importModeAndListenerManager = (Tuple)entry.getValue();
                    int oldImportMode = (Integer)importModeAndListenerManager.getT1();
                    if (oldImportMode == (newImportMode = importedObject.getImportMode())) continue;
                    changedObjects.add(importedObject);
                }
                for (IImportedObject importedObject : changedObjects) {
                    int newImportMode = importedObject.getImportMode();
                    Tuple oldImportModeAndListenerManager = (Tuple)ModelAccess.this.importModeChangeListeners.get(importedObject);
                    ListenerManager listenerManager = (ListenerManager)oldImportModeAndListenerManager.getT2();
                    Tuple newImportModeAndListenerManager = new Tuple((Object)newImportMode, (Object)listenerManager);
                    ModelAccess.this.importModeChangeListeners.put(importedObject, newImportModeAndListenerManager);
                    listenerManager.callListeners((IListenerCaller)new IListenerCaller<IImportModeChangeListener>(){

                        public void callListener(IImportModeChangeListener listener) {
                            listener.importModeChanged();
                        }
                    });
                }
            }
        });
    }

    private void removeImportJobChangeListener() {
        if (this.importJobChangeListenerKey != null) {
            this.importJob.removeChangeListener(this.importJobChangeListenerKey);
            this.importJobChangeListenerKey = null;
        }
    }

    public Locale getContentLocale() {
        return this.contentLocaleCache;
    }

    public Collection<? extends IModificationProblem> updateLocks(PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IMessageSet lockMessages = this.currentModelAndModificationsAccessAgent.getEditorMessageStorage().updateLocks();
        String humanReadableDescriptionOfConsequence = Messages.getString("ModelAccess.LocksDenied.Consequence", presentationContext.getLocale());
        return RepositoryAccessModificationProblem.convertIntoModificationProblems(this.repositoryTypeManager, lockMessages, presentationContext, humanReadableDescriptionOfConsequence);
    }

    public Object getObjectType(Object element) {
        IImportedObject importedObject = (IImportedObject)element;
        return importedObject.getObjectType();
    }

    public ITextProvider getMessageForException(EEXRepositoryException e) {
        final RepositoryException repositoryAccessException = (RepositoryException)e.getCause();
        return new ITextProvider(){

            public String getText(PresentationContext presentationContext) {
                return ModelAccess.this.getMessageForException(repositoryAccessException, presentationContext);
            }
        };
    }

    private String getMessageForException(RepositoryException repositoryAccessException, PresentationContext presentationContext) {
        return this.currentModelAndModificationsAccessAgent.getEditorMessageStorage().getMessageForException(repositoryAccessException, presentationContext);
    }

    public IMessageLevel getErrorLevelForException(EEXRepositoryAccessException e) {
        RepositoryAccessException repositoryAccessException = (RepositoryAccessException)e.getCause();
        return this.getErrorLevelForException(repositoryAccessException);
    }

    private IMessageLevel getErrorLevelForException(RepositoryAccessException repositoryAccessException) {
        return this.currentModelAndModificationsAccessAgent.getEditorMessageStorage().getErrorLevelForException(repositoryAccessException);
    }

    public void dispose() {
        this.isDisposing = true;
        this.removeImportJobChangeListener();
        for (Tuple<Integer, ListenerManager<IImportModeChangeListener>> listenerManager : this.importModeChangeListeners.values()) {
            ((ListenerManager)listenerManager.getT2()).dispose();
        }
        this.importModeChangeListeners.clear();
        this.modelChangeListeners.dispose();
        this.compareModeChangeListeners.dispose();
        this.currentModelAndModificationsAccessAgent.dispose();
        if (this.snapshotOrNullIfNotReproducible != null) {
            this.lockAndPermissionProvider.releaseAllLocks();
            this.snapshotOrNullIfNotReproducible = null;
        }
        this.isDisposing = false;
    }

    public IRepositorySnapshotRO getSnapshot() throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        if (this.snapshotOrNullIfNotReproducible == null) {
            if (this.exNotReproducibleSnapshot != null) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)this.exNotReproducibleSnapshot));
            }
            throw new EEXSnapshotClosed();
        }
        return this.snapshotOrNullIfNotReproducible;
    }

    public CurrentModelAndModificationsAccessAgent getCurrentModelAndModificationsAccessAgent() {
        return this.currentModelAndModificationsAccessAgent;
    }

    public ImportJobReferenceInterpreter getContentReferenceInterpreter() {
        return this.contentReferenceInterpreter;
    }

    public LockAndPermissionProvider getLockAndPermissionProvider() {
        return this.lockAndPermissionProvider;
    }

    public IModelChangeExecutionAgent getModelChangeExecutionAgent() {
        return null;
    }

    public void addInitialRelationSamples(ICollection_<? extends Object> samples) {
    }

    public ICollection_<? extends Object> getInitialRelationSamples() {
        return new ArrayList_(0);
    }

    public int getImportMode(Object object) {
        IImportedObject importedObject = (IImportedObject)object;
        return this.currentModelAndModificationsAccessAgent.getImportMode(importedObject);
    }

    public void setImportMode(Object object, int mode) throws EEXNotReproducibleSnapshot {
        IImportedObject importedObject = (IImportedObject)object;
        this.currentModelAndModificationsAccessAgent.setImportMode(importedObject, mode);
    }

    public boolean isMergeEnabled(Object object) {
        IImportedObject importedObject = (IImportedObject)object;
        return this.currentModelAndModificationsAccessAgent.isMergeEnabled(importedObject);
    }

    public void addModelChangeListener(ListenerKey key, IModelChangeListener listener) {
        this.modelChangeListeners.addListener(key, (IDisposeListener)listener);
    }

    public void removeModelChangeListener(ListenerKey key) {
        this.modelChangeListeners.removeListener(key);
    }

    public void addCompareModeChangeListener(ListenerKey key, ICompareModeChangeListener listener) {
        this.compareModeChangeListeners.addListener(key, (IDisposeListener)listener);
    }

    public void removeCompareModeChangeListener(ListenerKey key) {
        this.compareModeChangeListeners.removeListener(key);
    }

    public void addImportModeChangeListener(ListenerKey key, Object objectReference, IImportModeChangeListener listener) {
        IImportedObject importedObject = (IImportedObject)objectReference;
        Tuple listenerManager = this.importModeChangeListeners.get(importedObject);
        if (listenerManager == null) {
            listenerManager = new Tuple((Object)importedObject.getImportMode(), (Object)new ListenerManager());
            this.importModeChangeListeners.put(importedObject, (Tuple<Integer, ListenerManager<IImportModeChangeListener>>)listenerManager);
        }
        ((ListenerManager)listenerManager.getT2()).addListener(key, (IDisposeListener)listener);
    }

    public void removeImportModeChangeListener(ListenerKey key, Object objectReference) {
        IImportedObject importedObject = (IImportedObject)objectReference;
        Tuple<Integer, ListenerManager<IImportModeChangeListener>> listenerManager = this.importModeChangeListeners.get(importedObject);
        ((ListenerManager)listenerManager.getT2()).removeListener(key);
        if (!this.isDisposing && ((ListenerManager)listenerManager.getT2()).hasNoListeners()) {
            ((ListenerManager)listenerManager.getT2()).dispose();
            this.importModeChangeListeners.remove(importedObject);
        }
    }

    public int getCompareMode() {
        return this.compare_mode;
    }

    public void setCompareMode(int compare_mode) {
        this.compare_mode = compare_mode;
        this.compareModeChangeListeners.callListeners((IListenerCaller)new IListenerCaller<ICompareModeChangeListener>(){

            public void callListener(ICompareModeChangeListener listener) {
                listener.compareModeChanged();
            }
        });
    }

    public void setupModelAccessListener(IModelAccessListener listener) {
    }

    public IStreamResource getIcon16x16(Object object, PresentationContext presentationContext) {
        try {
            IImportedObject importedObject = (IImportedObject)object;
            IRepositoryObjectType repositoryObjectType = importedObject.getObjectType().getObjectType();
            IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
            IExpiringFrontendLabel labelForObject = frontendTypeManager.getLabelForObject(ImportJobHelper.getObjectSample((IImportedObject)importedObject, (IRepositorySnapshotRO)this.getSnapshot()), presentationContext);
            return labelForObject.getIcon16x16();
        }
        catch (EEXNotReproducibleSnapshot e) {
            LOGGER.error("Not reproducible snapshot when retrieving icon for import editor", (Throwable)e);
            return null;
        }
        catch (EEXSnapshotClosed e) {
            LOGGER.error("Snapshot closed when retrieving icon for import editor", (Throwable)e);
            return null;
        }
    }

    public String getName(Object object, PresentationContext presentationContext) {
        try {
            IImportedObject importedObject = (IImportedObject)object;
            IRepositoryObjectType repositoryObjectType = importedObject.getObjectType().getObjectType();
            IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
            IExpiringFrontendLabel labelForObject = frontendTypeManager.getLabelForObject(ImportJobHelper.getObjectSample((IImportedObject)importedObject, (IRepositorySnapshotRO)this.getSnapshot()), presentationContext);
            return labelForObject.getText();
        }
        catch (EEXNotReproducibleSnapshot e) {
            LOGGER.error("Not reproducible snapshot when retrieving icon for import editor", (Throwable)e);
            return null;
        }
        catch (EEXSnapshotClosed e) {
            LOGGER.error("Snapshot closed when retrieving icon for import editor", (Throwable)e);
            return null;
        }
    }

    public String getToolTipText(Object object, PresentationContext presentationContext) {
        IImportedObject importedObject = (IImportedObject)object;
        return this.getName(importedObject, presentationContext);
    }

    public ILayout createLayout(Object object) {
        IImportedObject importedObject = (IImportedObject)object;
        IRepositoryObjectType repositoryObjectType = importedObject.getObjectType().getObjectType();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(this.repositoryTypeManager);
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
        Sequence layoutSpecification = frontendObjectType.getSequentialLayoutSpecification();
        final List<WidgetReference> generatedLayout = layoutSpecification != null ? ImportJobEditorLayoutFactory.generateLayout(importedObject, repositoryObjectType, layoutSpecification) : ImportJobEditorLayoutFactory.generateDefaultLayout(importedObject, repositoryObjectType);
        return new ILayout(){

            public List<WidgetReference> getLayout() {
                return generatedLayout;
            }
        };
    }
}

