/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Value;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValueNow;
import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import java.util.Date;

public class ConditionValue1IsLowerThanValue2
implements Condition {
    private final Value value1;
    private final Value value2;

    public ConditionValue1IsLowerThanValue2(Value value1, Value value2) {
        Assert.checkArgumentBeeingNotNull((Object)value1);
        Assert.checkArgumentBeeingNotNull((Object)value2);
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public boolean isTrue(LabelCreationContext labelCreationContext) {
        boolean values1IsLowerThanValue2;
        IRepositoryData repositoryData1 = this.value1.getValue(labelCreationContext);
        IRepositoryData repositoryData2 = this.value2.getValue(labelCreationContext);
        if (repositoryData1 != null && repositoryData2 != null) {
            IRepositoryDataType repositoryDataType2;
            IRepositoryDataType repositoryDataType1 = repositoryData1.getDataType();
            if (repositoryDataType1 == (repositoryDataType2 = repositoryData2.getDataType())) {
                IRepositoryDataOrderComparator comparator = repositoryDataType1.getOrderComparator();
                if (comparator != null) {
                    IRepositoryDataTypeParameters parameters1 = this.value1.getRepositoryDataTypeParameters(labelCreationContext);
                    IRepositoryDataTypeParameters parameters2 = this.value2.getRepositoryDataTypeParameters(labelCreationContext);
                    int sgn1 = comparator.getSgn(repositoryData1, repositoryData2, parameters1);
                    int sgn2 = comparator.getSgn(repositoryData1, repositoryData2, parameters2);
                    int sgn = sgn1 == 0 ? sgn2 : (sgn2 == 0 ? sgn1 : (sgn1 == sgn2 ? sgn1 : 0));
                    values1IsLowerThanValue2 = sgn < 0;
                } else {
                    values1IsLowerThanValue2 = false;
                }
            } else {
                values1IsLowerThanValue2 = false;
            }
        } else {
            values1IsLowerThanValue2 = false;
        }
        return values1IsLowerThanValue2;
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        Object expirationDate;
        IRepositoryData repositoryData1 = this.value1.getValue(labelCreationContext);
        IRepositoryData repositoryData2 = this.value2.getValue(labelCreationContext);
        if (repositoryData1 != null && repositoryData2 != null) {
            RDTDateUTC64Bitmsec rdtDateUTC64Bitmsec = RDTDateUTC64Bitmsec.getInstance();
            IRepositoryDataOrderComparator comparator = rdtDateUTC64Bitmsec.getOrderComparator();
            IRepositoryDataType repositoryDataType1 = repositoryData1.getDataType();
            IRepositoryDataType repositoryDataType2 = repositoryData2.getDataType();
            if (repositoryDataType1 == rdtDateUTC64Bitmsec && repositoryDataType2 == rdtDateUTC64Bitmsec) {
                Date date1 = rdtDateUTC64Bitmsec.dataToValue(repositoryData1);
                Date date2 = rdtDateUTC64Bitmsec.dataToValue(repositoryData2);
                int sgn = comparator.getSgn(repositoryData1, repositoryData2, (IRepositoryDataTypeParameters)RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_MS);
                expirationDate = this.value1 instanceof ValueNow && !(this.value2 instanceof ValueNow) ? (sgn < 0 ? date2 : (sgn == 0 ? null : null)) : (this.value2 instanceof ValueNow && !(this.value1 instanceof ValueNow) ? (sgn < 0 ? null : (sgn == 0 ? date1 : date1)) : null);
            } else {
                expirationDate = null;
            }
        } else {
            expirationDate = null;
        }
        return expirationDate;
    }
}

