/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeString;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import java.util.Locale;

public class FDTFreeString
extends AbstractFrontendDataTypeString {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTFreeString.class, "freestring.gif");
    private final RDTFreeString repositoryDataType = RDTFreeString.getInstance();

    public static FDTFreeString getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTFreeString frontendDataType = (FDTFreeString)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTFreeString.getInstance());
        return frontendDataType;
    }

    public FDTFreeString(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTFreeString", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel label;
        String typedValue = this.repositoryDataType.dataToValue(value);
        if (typedValue != null) {
            typedValue = StringUtil.removeLineBreaksAndControlCharacters((String)typedValue);
            label = new FrontendLabel(typedValue, null);
        } else {
            label = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataTypeString.FETAbstractRepositoryStringDataTypeValueInvalid.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.repositoryDataType.dataToValue(value);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTFreeString(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final Parameters DEFAULTS = new Parameters();
    }
}

