/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.richclientapplication;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptAuthenticator;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptCommandContext;
import com.arcway.cockpit.frame.client.global.consoleui.ScriptInterpreter;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.java.ObjectWrapper;
import java.io.File;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

class ScriptInterpreterLauncher
extends Thread {
    private final File scriptfile;
    private final File logDirParentDir;

    public ScriptInterpreterLauncher(File scriptfile, File logDirParentDir) {
        this.scriptfile = scriptfile;
        this.logDirParentDir = logDirParentDir;
    }

    @Override
    public void run() {
        ProjectMgr.setIsInScriptMode((boolean)true);
        this.setName("Cockpit Script Interpreter");
        boolean workbenchStarted = false;
        while (!workbenchStarted) {
            try {
                ScriptInterpreterLauncher.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            workbenchStarted = ScriptInterpreterLauncher.checkWorkbenchRunning();
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        try {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ScriptAuthenticator.installAsSystemAuthenticator();
                    IWorkbenchPage workbenchPage = EclipseSWTHelper.getWorkbenchPage(null);
                    ScriptCommandContext uiContext = new ScriptCommandContext(null, workbenchPage, null);
                    ScriptInterpreter scriptInterpreter = ScriptInterpreter.createScriptInterpreter((File)ScriptInterpreterLauncher.this.scriptfile, (File)ScriptInterpreterLauncher.this.logDirParentDir, (ScriptCommandContext)uiContext);
                    scriptInterpreter.executeScriptAndLogExecution();
                }
            });
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        ScriptInterpreterLauncher.shutdownWorkbench();
    }

    private static boolean checkWorkbenchRunning() {
        boolean workbenchIsRunngin = PlatformUI.isWorkbenchRunning();
        if (workbenchIsRunngin) {
            boolean running = false;
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                final ObjectWrapper runningFlagWrapper = new ObjectWrapper(null);
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        runningFlagWrapper.setWrappedObject((Object)(PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? 1 : 0));
                    }
                });
                running = (Boolean)runningFlagWrapper.getWrappedObject();
            }
            workbenchIsRunngin &= running;
        }
        return workbenchIsRunngin;
    }

    private static void shutdownWorkbench() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().close();
            }
        });
    }
}

