/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.requirementsmodule2migrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RQM2_TO_RQM3_PermissionMigrator2
implements ICockpitMigrator {
    public static final String KEY = "requirementsmodule-2-permission-migrator-2";
    private static final Map<String, String> RQM2_PERMISSIONS = new HashMap<String, String>();

    static {
        RQM2_PERMISSIONS.put("editRequirementSets", "rqm2.set");
        RQM2_PERMISSIONS.put("modifyAllAttributes\nrqm2.set", "rqm2.set");
        RQM2_PERMISSIONS.put("editCategoryRange", "GENERAL_RQM_PERMISSIONS");
        RQM2_PERMISSIONS.put("modifyAllAttributes\nrqm2.requirement", "rqm2.set");
        RQM2_PERMISSIONS.put("editStatesRange", "GENERAL_RQM_PERMISSIONS");
        RQM2_PERMISSIONS.put("editVersionRange", "GENERAL_RQM_PERMISSIONS");
        RQM2_PERMISSIONS.put("linkRequirements", "rqm2.set");
        RQM2_PERMISSIONS.put("deleteRequirementSets", "rqm2.set");
        RQM2_PERMISSIONS.put("editRequirements", "rqm2.set");
        RQM2_PERMISSIONS.put("deleteRequirements", "rqm2.set");
        RQM2_PERMISSIONS.put("editNoteCategoryRange", "GENERAL_RQM_PERMISSIONS");
    }

    public String getKey() {
        return KEY;
    }

    public int getSourceVersion() {
        return 4;
    }

    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
            List projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    EOList permissions = historicView.readPermissions(currentProject);
                    RQM2_TO_RQM3_PermissionMigrator2.migratePermissions((Collection<EOPermission>)permissions);
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }

    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    private void migrateACTorACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            EOList basePermissionList = projectFileView_3_.getDataList("permissions");
            RQM2_TO_RQM3_PermissionMigrator2.migratePermissions((Collection<EOPermission>)basePermissionList);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException((Throwable)pfaE);
        }
    }

    private static void migratePermissions(Collection<EOPermission> permissions) {
        ArrayList<EOPermission> permissionsToRemove = new ArrayList<EOPermission>();
        for (EOPermission permission : permissions) {
            String operationKey = permission.getOperation();
            if (permission.getOperation2() != null) {
                operationKey = String.valueOf(operationKey) + "\n" + permission.getOperation2();
            }
            if (!RQM2_PERMISSIONS.containsKey(operationKey) || !RQM2_PERMISSIONS.get(operationKey).equals(permission.getOperandType())) continue;
            permissionsToRemove.add(permission);
        }
        permissions.removeAll(permissionsToRemove);
    }
}

