/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.SingleWizardProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.wizard.PlansImportWizard;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.resource.IStreamResource;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;

public abstract class AbstractPlanImportWizardProvider
extends SingleWizardProvider {
    private final IPlansConverter planConverter = this.createPlansConverter();

    protected abstract IPlansConverter createPlansConverter();

    public boolean validForSelectedElement(Object selectedElement) {
        return selectedElement instanceof IFrameProjectAgent || selectedElement instanceof ISection;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageCache.getImageDescriptor((IStreamResource)this.planConverter.getIcon16x16());
    }

    public String getID() {
        return this.planConverter.getID();
    }

    public String getName() {
        return this.planConverter.getLocalizedName(Locale.getDefault());
    }

    public String getDescription() {
        return this.planConverter.getLocalizedDescription(Locale.getDefault());
    }

    public IWizard getWizard(Object selectedElement) {
        if (selectedElement instanceof ICockpitProjectData) {
            ISection section = (ISection)selectedElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            return new PlansImportWizard((IFrameProjectAgent)projectAgent, section, this.planConverter);
        }
        return null;
    }

    public String getPermissionError() {
        return "";
    }

    public boolean hasPermissionForSelectedElement(Object selectedElement) {
        return true;
    }
}

