/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.version3.framework;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOContainer_V0;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IAttributeValueConverter;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EnumAttributeValueConverter
implements IAttributeValueConverter {
    private final EOList<EOContainer_V0<EOString>> enumValueRange;
    private final Map<String, String> id_2_label;

    public static EOList<EOContainer_V0<EOString>> transformAttributeValue(String value, String displayName) {
        Assert.checkArgumentBeeingNotNull((Object)value);
        Assert.checkArgumentBeeingNotNull((Object)displayName);
        EOList list = new EOList(1);
        list.add((EncodableObjectBase)new EOContainer_V0(value, (EOEncodableObject)new EOString(displayName)));
        return list;
    }

    public EnumAttributeValueConverter(Map<String, String> id_2_label) {
        this.id_2_label = new HashMap<String, String>(id_2_label);
        Set<Map.Entry<String, String>> entrySet = id_2_label.entrySet();
        ArrayList<Map.Entry<String, String>> valueMappingEntries = new ArrayList<Map.Entry<String, String>>(entrySet);
        Collections.sort(valueMappingEntries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String label1 = o1.getValue();
                String label2 = o2.getValue();
                return label1.compareTo(label2);
            }
        });
        this.enumValueRange = new EOList(valueMappingEntries.size());
        for (Map.Entry entry : valueMappingEntries) {
            String id = (String)entry.getKey();
            String label = (String)entry.getValue();
            assert (label != null && label.length() > 0);
            this.enumValueRange.add((EncodableObjectBase)new EOContainer_V0(id, (EOEncodableObject)new EOString(label)));
        }
    }

    public EnumAttributeValueConverter() {
        this.id_2_label = new HashMap<String, String>();
        this.enumValueRange = new EOList(this.id_2_label.size());
    }

    public void put(String id, String label) {
        assert (label != null && label.length() > 0);
        this.id_2_label.put(id, label);
        this.enumValueRange.add((EncodableObjectBase)new EOContainer_V0(id, (EOEncodableObject)new EOString(label)));
    }

    public EOList<EOContainer_V0<EOString>> getValueRange() {
        return this.enumValueRange;
    }

    public EOList<EOContainer_V0<EOString>> transformAttributeValue(String value) {
        return EnumAttributeValueConverter.transformAttributeValue(value, this.id_2_label.get(value));
    }

    @Override
    public boolean isEmptyValue(String value) {
        return value == null || value.equals("") || value.equals("0");
    }

    public Map<String, String> getID_2_Label() {
        return this.id_2_label;
    }
}

