/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.transfer;

import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ModuleDataTransferAgent
extends AbstractTransferAgentForMultipleObjectTransfer {
    private static final String TYPE_NAME_PREFIX = "TransferType_ModuleData_SingleItem-";
    private static final MessageDataFactory eoFactory = MessageDataFactory.getInstance();
    private static final XMLDecoder xmlDecoder = new XMLDecoder();
    private static Map<String, ModuleDataTransferAgent> map_typeID_singletonInstance = new HashMap<String, ModuleDataTransferAgent>();
    private final IClientDataFactory dataFactory;

    public static ModuleDataTransferAgent getInstance(String typeID, IClientDataFactory clientDataFactory) {
        ModuleDataTransferAgent transferAgent = map_typeID_singletonInstance.get(typeID);
        if (transferAgent == null) {
            transferAgent = new ModuleDataTransferAgent(typeID, clientDataFactory);
            map_typeID_singletonInstance.put(typeID, transferAgent);
        }
        return transferAgent;
    }

    public static ModuleDataTransferAgent getInstance(String typeID) {
        return map_typeID_singletonInstance.get(typeID);
    }

    private ModuleDataTransferAgent(String typeID, IClientDataFactory clientDataFactory) {
        super(TYPE_NAME_PREFIX + typeID);
        this.dataFactory = clientDataFactory;
    }

    protected byte[] javaToByteArray(Object dataAsObject) throws ExByteArrayEncodingFailed {
        try {
            IModuleData moduleData = (IModuleData)dataAsObject;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            EOModuleData eo = moduleData.createEncodableObject();
            eo.writeToXMLStream((OutputStream)out, false);
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new ExByteArrayEncodingFailed("Could not serialize", (Throwable)e);
        }
        catch (EXEncoderException e) {
            throw new ExByteArrayEncodingFailed("Could not serialize", (Throwable)e);
        }
    }

    protected Object byteArrayToJava(byte[] dataAsByteArray, int dataStartPos, int dataLength) throws ExByteArrayDecodingFailed {
        IModuleData moduleData = null;
        if (dataAsByteArray != null) {
            EOModuleData eo;
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(dataAsByteArray, dataStartPos, dataLength);
            try {
                eo = (EOModuleData)xmlDecoder.decodeXML((InputStream)byteInputStream, (IEncodableObjectFactory)eoFactory, true);
            }
            catch (EXDecoderException e) {
                throw new ExByteArrayDecodingFailed("Could not deserialise EOModuleData xml.", (Throwable)e);
            }
            try {
                moduleData = this.dataFactory.convertFromEO(eo);
            }
            catch (Exception e) {
                throw new ExByteArrayDecodingFailed("Could not deserialise EOModuleData xml.", (Throwable)e);
            }
            assert (moduleData != null);
        }
        return moduleData;
    }
}

