/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.attributes;

import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeText;
import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.ILong;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueRangeHelperTimestamp;
import java.sql.Timestamp;
import java.util.Locale;

public class ModuleDataAttributeTimestamp
implements IModuleDataAttributeText,
ILong {
    private static final String ZERO_NON_NULL = "zero-non-null";
    private Long value;
    private final ValueRangeHelperTimestamp valueRangeHelper;

    public ModuleDataAttributeTimestamp() {
        this(true);
    }

    public ModuleDataAttributeTimestamp(boolean includeTime) {
        this(null, includeTime);
    }

    public ModuleDataAttributeTimestamp(Long value, boolean includeTime) {
        this.valueRangeHelper = new ValueRangeHelperTimestamp((ILong)this, includeTime);
        this.setValue(value);
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long newValue) {
        this.value = this.valueRangeHelper.getIncludeTime() ? newValue : ModuleDataAttributeTimestamp.normalizeDateTimeStamp(newValue);
    }

    public void setValue(long newValue) {
        this.setValue(new Long(newValue));
    }

    public boolean isTimeIncluded() {
        return this.valueRangeHelper.getIncludeTime();
    }

    @Override
    public IModuleDataAttribute copy() {
        return new ModuleDataAttributeTimestamp(this.getValue(), this.valueRangeHelper.getIncludeTime());
    }

    @Override
    public String getDisplayStringRepresentation() {
        return this.valueRangeHelper.getDisplayFormat();
    }

    @Override
    public String getDisplayStringRepresentation(Locale locale) {
        return this.valueRangeHelper.getDisplayFormat(locale);
    }

    public SetterSuccess setValueViaDisplayStringRepresentation(String displayRepresentation, Locale locale) {
        return this.valueRangeHelper.setPersistentValue(displayRepresentation, locale);
    }

    @Override
    public SetterSuccess setValueViaDisplayStringRepresentation(String displayRepresentation) {
        return this.valueRangeHelper.setPersistentValue(displayRepresentation);
    }

    @Override
    public String getUniqueStringRepresentation() {
        if (this.value != null) {
            if (this.value == 0L) {
                return ZERO_NON_NULL;
            }
            return this.value.toString();
        }
        return "0";
    }

    @Override
    public boolean setValueViaUniqueStringRepresentation(String uniqueStringRepresentation) {
        Long oldValue = this.value;
        if (uniqueStringRepresentation == null) {
            this.setValue(null);
        } else if (uniqueStringRepresentation.equals("0")) {
            this.setValue(null);
        } else if (uniqueStringRepresentation.equals(ZERO_NON_NULL)) {
            this.setValue(new Long(0L));
        } else {
            try {
                this.setValue(new Long(Long.parseLong(uniqueStringRepresentation)));
            }
            catch (NumberFormatException e) {
                this.setValue(null);
            }
        }
        return this.value == null && oldValue != null || this.value != null && !this.value.equals(oldValue);
    }

    @Override
    public IValueRangeHelperText getValueRangeHelper() {
        return new ValueRangeHelperTimestamp((ILong)this, this.valueRangeHelper.getIncludeTime());
    }

    public Timestamp getValueAsTimeStamp() {
        return this.valueRangeHelper.getValue();
    }

    public static Long normalizeDateTimeStamp(Long timestamp) {
        if (timestamp != null) {
            long normalisedTimestamp = timestamp;
            normalisedTimestamp += 0x6DDD00L;
            normalisedTimestamp = normalisedTimestamp - ModuleDataAttributeTimestamp.modulo(normalisedTimestamp, 86400000L) + 43200000L;
            return new Long(normalisedTimestamp -= 0x6DDD00L);
        }
        return null;
    }

    private static long modulo(long value, long modulus) {
        long modulo = value % modulus;
        if (modulo < 0L) {
            modulo += modulus;
        }
        return modulo;
    }
}

