/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages;

import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper_Core;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashSet;

public class DataTypesHelper
implements IDataTypesHelper {
    private final IDataTypesHelper_Core dataTypesHelper_Core;
    private Collection<String> rootDocumentationDataTypes;
    private Collection<String> nonRootDocumentationDataTypes;
    private Collection<String> trueDataTypes;
    private Collection<String> allDataTypes;
    private Collection<String> customPropertyDataTypes;
    private Collection<String> documentationCustomPropertyDataTypes;
    private SetMap<String, String> map_parentTypeID_childTypeIDs;

    public DataTypesHelper(IDataTypesHelper_Core dataTypesHelper_Core) {
        this.dataTypesHelper_Core = dataTypesHelper_Core;
        this.construct();
    }

    private void construct() {
        ModuleDataTypeDescriptionForFrame frameDescription;
        this.rootDocumentationDataTypes = new HashSet<String>();
        this.nonRootDocumentationDataTypes = new HashSet<String>();
        this.trueDataTypes = new HashSet<String>();
        this.allDataTypes = new HashSet<String>();
        this.customPropertyDataTypes = new HashSet<String>();
        this.documentationCustomPropertyDataTypes = new HashSet<String>();
        this.map_parentTypeID_childTypeIDs = new SetMap();
        for (String typeID : this.getDocumentationDataTypes()) {
            if (this.getParentTypeIDs(typeID).contains("hierarchyroot")) {
                this.rootDocumentationDataTypes.add(typeID);
                this.map_parentTypeID_childTypeIDs.add((Object)"hierarchyroot", (Object)typeID);
            } else {
                this.nonRootDocumentationDataTypes.add(typeID);
            }
            for (String potentialChildTypeID : this.getDocumentationDataTypes()) {
                if (!this.getParentTypeIDs(potentialChildTypeID).contains(typeID)) continue;
                this.map_parentTypeID_childTypeIDs.add((Object)typeID, (Object)potentialChildTypeID);
            }
            frameDescription = this.getTypeDescription(typeID).getModuleDataTypeDescriptionForFrame();
            if (!frameDescription.allowsUserDefinedAttributeTypes()) continue;
            this.customPropertyDataTypes.add(typeID);
            this.documentationCustomPropertyDataTypes.add(typeID);
        }
        for (String typeID : this.getAdministrativeDataTypes()) {
            frameDescription = this.getTypeDescription(typeID).getModuleDataTypeDescriptionForFrame();
            if (!frameDescription.allowsUserDefinedAttributeTypes()) continue;
            this.customPropertyDataTypes.add(typeID);
        }
        this.trueDataTypes.addAll(this.getAdministrativeDataTypes());
        this.trueDataTypes.addAll(this.getDocumentationDataTypes());
        this.allDataTypes.addAll(this.getAdministrativeDataTypes());
        this.allDataTypes.addAll(this.getDocumentationDataTypes());
        this.allDataTypes.addAll(this.getVirtualDataTypes());
    }

    @Override
    public Collection<String> getRootDocumentationDataTypes() {
        return this.rootDocumentationDataTypes;
    }

    @Override
    public Collection<String> getNonRootDocumentationDataTypes() {
        return this.nonRootDocumentationDataTypes;
    }

    @Override
    public Collection<String> getAllTrueDataTypes() {
        return this.trueDataTypes;
    }

    @Override
    public Collection<String> getAllDataTypes() {
        return this.allDataTypes;
    }

    @Override
    public Collection<String> getCustomPropertyDataTypes() {
        return this.customPropertyDataTypes;
    }

    @Override
    public Collection<String> getDocumentationCustomPropertyDataTypes() {
        return this.documentationCustomPropertyDataTypes;
    }

    @Override
    public Collection<String> getChildTypeIDs(String parentTypeID) {
        return this.map_parentTypeID_childTypeIDs.get((Object)parentTypeID);
    }

    @Override
    public Collection<String> getAdministrativeDataTypes() {
        return this.dataTypesHelper_Core.getAdministrativeDataTypes();
    }

    @Override
    public boolean isAdministrativeDataType(String typeID) {
        return this.dataTypesHelper_Core.getAdministrativeDataTypes().contains(typeID);
    }

    @Override
    public Collection<String> getDocumentationDataTypes() {
        return this.dataTypesHelper_Core.getDocumentationDataTypes();
    }

    @Override
    public boolean isDocumentationDataType(String typeID) {
        return this.dataTypesHelper_Core.getDocumentationDataTypes().contains(typeID);
    }

    @Override
    public Collection<String> getVirtualDataTypes() {
        return this.dataTypesHelper_Core.getVirtualDataTypes();
    }

    @Override
    public Collection<String> getParentTypeIDs(String childTypeID) {
        return this.dataTypesHelper_Core.getParentTypeIDs(childTypeID);
    }

    @Override
    public IModuleDataTypeDescription getTypeDescription(String typeID) {
        return this.dataTypesHelper_Core.getTypeDescription(typeID);
    }
}

