/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure;

import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.IEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Editor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EditorLayoutSpecification
extends AbstractEditorSpecificationPart {
    private final Map<String, Editor> editorMap = new HashMap<String, Editor>();

    public EditorLayoutSpecification(List<Editor> editorList) {
        int editorListCounter = 1;
        for (Editor part : editorList) {
            part.setIndex(editorListCounter);
            String partID = part.getID();
            this.editorMap.put(partID, part);
            ++editorListCounter;
        }
    }

    public List<Editor> getEditorList() {
        ArrayList<Editor> list = new ArrayList<Editor>(this.editorMap.values());
        EditorLayoutSpecification.sortSpecificationPartList(list);
        return list;
    }

    public Editor getEditor(String id) {
        return this.editorMap.get(id);
    }

    public Editor getEditor(int index) {
        return this.getEditorList().get(index);
    }

    public List<IEditorSpecificationPart> getChildren() {
        ArrayList<IEditorSpecificationPart> children = new ArrayList<IEditorSpecificationPart>();
        children.addAll(this.editorMap.values());
        return children;
    }

    @Override
    public String getTypeID() {
        return "EditorLayoutSpecification";
    }
}

