/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ViewModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPage;

public class ModuleDataCustomWizardPage
extends WizardPage
implements IPropertiesDialog,
IObjectTypeCategoryChangeListener {
    private static final ILogger logger = Logger.getLogger(ModuleDataCustomWizardPage.class);
    private final IModelController model;
    private IModuleData_CustomPropertiesExtension item;
    private AbstractModuleAttributeAgent attributeAgent;
    AttributeTypesComposite uaControl;
    private ScrolledComposite scrolledComposite;

    public ModuleDataCustomWizardPage(IModelController model, String dataType) {
        super(String.valueOf(dataType) + ".customProperties");
        assert (model != null) : "model must not be null";
        this.model = model;
    }

    public boolean mayModify() {
        return true;
    }

    public String getProjectUID() {
        return this.item.getProjectUID();
    }

    public void createControl(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setSize(parent.getClientArea().width, parent.getClientArea().height);
        this.uaControl = new AttributeTypesComposite((IAttributeOwner)this.attributeAgent, (Composite)this.scrolledComposite, false, true, true, (IPropertiesDialog)this, IPropertiesListEntry.DUMMY);
        this.uaControl.create(null);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (ModuleDataCustomWizardPage.this.scrolledComposite.getContent() == null) {
                    ModuleDataCustomWizardPage.this.scrolledComposite.setContent((Control)ModuleDataCustomWizardPage.this.uaControl.getComposite());
                    ModuleDataCustomWizardPage.this.adjustScrolledComposite();
                }
            }
        });
        this.setControl((Control)this.scrolledComposite);
    }

    private void adjustScrolledComposite() {
        Point preferedSize = this.uaControl.getComposite().computeSize(-1, -1);
        this.uaControl.getComposite().setSize(preferedSize);
        this.scrolledComposite.setMinSize(0, preferedSize.y);
    }

    public void setTitle(String title, IPropertiesListEntry entry) {
        this.setTitle(title);
    }

    public void setMessage(String message, int severity, IPropertiesListEntry caller) {
        this.setMessage(message, severity);
    }

    public IWorkbenchPage getWorkbenchPage() {
        return null;
    }

    public void setIsCommitable(boolean isCommitable, IPropertiesListEntry caller) {
        this.setPageComplete(true);
    }

    public void setIsCancelable(boolean isCancelable, IPropertiesListEntry caller) {
    }

    public void setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            IModuleData parent = parents.length > 0 ? parents[0] : null;
            this.item = items[0];
            this.attributeAgent = new ViewModuleAttributeAgent(this.item, this.model.getProjectAgent().getModuleUserDefinedAttributeTypesManager(), this.model, parent);
        } else {
            logger.error("Can't handle multiple items");
        }
    }

    public boolean performFinish() {
        Collection changedAttributes = this.uaControl.getNewAttributes();
        for (IAttribute attribute : changedAttributes) {
            try {
                this.attributeAgent.modifyAttributeAndNotifyDataType(attribute, null);
            }
            catch (ExInvalidAttributeType e) {
                logger.error((Throwable)e);
            }
            catch (ExInvalidDataType e) {
                logger.error((Throwable)e);
            }
        }
        this.uaControl.dispose();
        return true;
    }

    public boolean performCancel() {
        this.uaControl.dispose();
        return true;
    }

    public void categoryChanged(ObjectTypeCategory category) {
        if (this.uaControl != null) {
            this.uaControl.categoryChanged(category);
            this.adjustScrolledComposite();
        }
    }
}

