/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewSortingState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.frame.client.project.sequences.ISequencerManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class StandardTreeDataViewSorter
extends TreeDataViewSorter<IModuleData> {
    static final ILogger logger = Logger.getLogger(StandardTreeDataViewSorter.class);
    private IModelController modelController;
    private static final Set<String> LOW_PRIO_DATA_TYPES = new HashSet<String>();

    static {
        LOW_PRIO_DATA_TYPES.add("com.arcway.cockpit.genericmodule.issuemodule2.issueSet");
        LOW_PRIO_DATA_TYPES.add("com.arcway.cockpit.genericmodule.itilmodule.folder");
        LOW_PRIO_DATA_TYPES.add("com.arcway.cockpit.genericmodule.organisationalmanualmodule.folder");
        LOW_PRIO_DATA_TYPES.add("com.arcway.cockpit.genericmodule.requirementsmodule3.requirementSet");
        LOW_PRIO_DATA_TYPES.add("com.arcway.cockpit.genericmodule.swotmodule.folder");
    }

    public StandardTreeDataViewSorter(IModelController modelController, IDataViewSortingState sortingState) {
        super(sortingState);
        this.modelController = modelController;
    }

    protected Integer compareAccordingToType(IModuleData moduleData1, IModuleData moduleData2) {
        IModuleDataTypeDescription typeDescription1 = moduleData1.getTypeDescription();
        IModuleDataTypeDescription typeDescription2 = moduleData2.getTypeDescription();
        IModuleDataTypeDescriptionForFrame dataTypeForNaturalOrdering1 = typeDescription1.getDataTypeForNaturalOrdering();
        IModuleDataTypeDescriptionForFrame dataTypeForNaturalOrdering2 = typeDescription2.getDataTypeForNaturalOrdering();
        if (dataTypeForNaturalOrdering1 == null) {
            if (dataTypeForNaturalOrdering2 == null) {
                return null;
            }
            return 1;
        }
        if (dataTypeForNaturalOrdering2 == null) {
            return -1;
        }
        if (!dataTypeForNaturalOrdering1.equals(dataTypeForNaturalOrdering2)) {
            int naturalOrderPriority1 = typeDescription1.getNaturalOrderPriority();
            if (LOW_PRIO_DATA_TYPES.contains(typeDescription1.getTypeID())) {
                naturalOrderPriority1 = 10000 - naturalOrderPriority1;
            }
            int naturalOrderPriority2 = typeDescription2.getNaturalOrderPriority();
            if (LOW_PRIO_DATA_TYPES.contains(typeDescription2.getTypeID())) {
                naturalOrderPriority2 = 10000 - naturalOrderPriority2;
            }
            return naturalOrderPriority1 - naturalOrderPriority2;
        }
        return null;
    }

    protected Integer compareAccordingToTypeSpecificRule(IModuleData moduleData1, IModuleData moduleData2) {
        if (!moduleData1.getTypeDescription().isNaturalOrderUserDetermined()) {
            Comparator<? extends IModuleData> specialComparator = moduleData1.getTypeDescription().getNaturalOrderComparator();
            if (specialComparator != null) {
                return specialComparator.compare(moduleData1, moduleData2);
            }
            assert (false) : "Special comparator must be given.";
            return 0;
        }
        return null;
    }

    protected Integer compareAccordingToNaturalOrder(IModuleData moduleData1, IModuleData moduleData2) {
        ISequencer sequencer = this.retrieveSequencer(moduleData1);
        return this.compareAccordingToNaturalOrder(moduleData1, moduleData2, sequencer);
    }

    private ISequencer retrieveSequencer(IModuleData moduleData) {
        IModuleData parent = this.modelController.getParent(moduleData);
        Object commonParentAttributeOwner = parent == null ? this.modelController.getProjectAgent().getProject() : this.modelController.getAttributeOwner(parent);
        IModuleDataTypeDescriptionForFrame dataType = moduleData.getTypeDescription().getDataTypeForNaturalOrdering();
        ISequencerManager sequencerManager = this.modelController.getProjectAgent().getSequencerManager();
        ISequencer sequencer = sequencerManager.getSequencer((IAttributeOwner)commonParentAttributeOwner, new ArrayList(), (ICockpitDataType)dataType);
        return sequencer;
    }

    private int compareAccordingToNaturalOrder(IModuleData moduleData1, IModuleData moduleData2, ISequencer sequencer) {
        int compareValue = sequencer.getComparator().compare(moduleData1, moduleData2);
        if (compareValue == 0) {
            long creationTimeDifference = moduleData1.getCreationTime().getValue() - moduleData2.getCreationTime().getValue();
            if (creationTimeDifference < 0L) {
                compareValue = -1;
            } else if (creationTimeDifference > 0L) {
                compareValue = 1;
            }
        }
        return compareValue;
    }

    public void destroyInternalStructure() {
        super.destroyInternalStructure();
        this.modelController = null;
    }

    public static TreeDataViewSorter<IModuleData> getSorterForNaturalOrder(IModelController modelController) {
        return new StandardTreeDataViewSorter(modelController, new IDataViewSortingState(){

            public int getColumnCount() {
                return 0;
            }

            public IDataViewColumnComparator getComparator(int sortingPriority) {
                return null;
            }

            public int getSortingDirection(int sortingPriority) {
                return 0;
            }

            public int getSortingMode() {
                return 1;
            }
        });
    }

    public static Comparator<IModuleData> getComparatorForNaturalOrder(IModelController modelController) {
        final TreeDataViewSorter<IModuleData> sorterForNaturalOrder = StandardTreeDataViewSorter.getSorterForNaturalOrder(modelController);
        return new Comparator<IModuleData>(){

            @Override
            public int compare(IModuleData o1, IModuleData o2) {
                return sorterForNaturalOrder.compare(null, (Object)o1, (Object)o2);
            }
        };
    }
}

