/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private final Map fRegistry = new HashMap(10);
    private final Display fDisplay;

    public ImageDescriptorRegistry() {
        this(AbstractModulePlugin.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        assert (display != null) : "display must not be null";
        this.fDisplay = display;
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        assert (this.fDisplay == AbstractModulePlugin.getStandardDisplay()) : "Allocating image for wrong display";
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.disposeExec(new Runnable(){

            @Override
            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

