/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.JFaceViewerDataView;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILinkTypeFilter;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.IModuleLinkViewContent;
import com.arcway.cockpit.modulelib2.client.gui.IUserInterface;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractLinkContentProvider
implements ILinkContentProvider,
ILinkTypeFilter {
    private boolean enableDataViewFilters = false;
    private final IUserInterface UI;

    public AbstractLinkContentProvider(IUserInterface UI) {
        this.UI = UI;
    }

    public void disableDataViewFilters() {
        this.enableDataViewFilters = false;
    }

    public void enableDataViewFilters() {
        this.enableDataViewFilters = true;
    }

    public void toggleDataViewFilters() {
        this.enableDataViewFilters = !this.enableDataViewFilters;
    }

    public List<? extends IModuleLinkViewContent> getLinkedModuleData(IUniqueElement element, Collection containedElements, Collection containerElements, boolean applyDataViewFilters) {
        List<? extends IModuleLinkViewContent> moduleDataLinks = this.doGetLinkedModuleData(element, containedElements, containerElements);
        Iterator<? extends IModuleLinkViewContent> i = moduleDataLinks.iterator();
        while (i.hasNext()) {
            IModuleLinkViewContent linkViewContent = i.next();
            if (applyDataViewFilters) {
                this.filterLinkViewContent(linkViewContent);
            }
            if (!linkViewContent.isEmpty()) continue;
            i.remove();
        }
        return moduleDataLinks;
    }

    public final List<? extends IModuleLinkViewContent> getLinkedModuleData(IUniqueElement element, Collection containedElements, Collection containerElements) {
        return this.getLinkedModuleData(element, containedElements, containerElements, this.enableDataViewFilters);
    }

    protected abstract List<? extends IModuleLinkViewContent> doGetLinkedModuleData(IUniqueElement var1, Collection<? extends IUniqueElement> var2, Collection<? extends IUniqueElement> var3);

    public ILinkTypeFilter getFilterForModuleDataLinkTypes() {
        return this;
    }

    public boolean isLinkTypeToExclude(String linkTypeID) {
        return this.isLinkedModuleDataLinkType(linkTypeID);
    }

    protected abstract boolean isLinkedModuleDataLinkType(String var1);

    protected void filterLinkViewContent(IModuleLinkViewContent linkViewContent) {
        assert (linkViewContent != null) : "linkViewContent must not be null";
        AbstractDataView[] dataViews = this.UI.getDataViews(false);
        if (dataViews != null && dataViews.length > 0) {
            Iterator contentIterator = linkViewContent.iterator();
            while (contentIterator.hasNext()) {
                Object contentPart = contentIterator.next();
                if (contentPart instanceof IndirectLinksContainer) {
                    Iterator indirectLinksIterator = ((IndirectLinksContainer)contentPart).getLinkedModuleData().iterator();
                    while (indirectLinksIterator.hasNext()) {
                        IModuleData item = (IModuleData)indirectLinksIterator.next();
                        if (!this.isFiltered(item, dataViews)) continue;
                        indirectLinksIterator.remove();
                    }
                    if (!((IndirectLinksContainer)contentPart).getLinkedModuleData().isEmpty()) continue;
                    contentIterator.remove();
                    continue;
                }
                if (!(contentPart instanceof IModuleData) || !this.isFiltered((IModuleData)contentPart, dataViews)) continue;
                contentIterator.remove();
            }
        }
    }

    private boolean isFiltered(IModuleData item, AbstractDataView[] dataViews) {
        AbstractDataView[] abstractDataViewArray = dataViews;
        int n = dataViews.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDataView dataView = abstractDataViewArray[n2];
            if (dataView instanceof JFaceViewerDataView && ((JFaceViewerDataView)dataView).applyFilters(Collections.singleton(item)).isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IUserInterface getModuleUserInterface() {
        return this.UI;
    }

    protected static final boolean hasLinkedInformation(IUniqueElement uniqueElement, Collection<IUniqueElement> containedElements, Collection<IUniqueElement> containerElements, IModelController modelController, Collection<String> linkTypeIDs) {
        ArrayList<IUniqueElement> allUniqueElements = new ArrayList<IUniqueElement>(1 + containedElements.size() + containerElements.size());
        allUniqueElements.add(uniqueElement);
        allUniqueElements.addAll(containedElements);
        allUniqueElements.addAll(containerElements);
        for (IUniqueElement currentUniqueElement : allUniqueElements) {
            for (String linkType : linkTypeIDs) {
                if (modelController.getLinksForLinkableObject(currentUniqueElement.getUID(), linkType).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

