/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDouble;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeInteger;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeURL;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EnumValueReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.ExistingAttributeReference;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeLong;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributePath;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TargetAttributeDescription
implements ITargetAttributeDescription<ExistingAttributeReference, Integer, EnumValueReference> {
    public static final int KIND_FIXATTRIBUTE = 1;
    public static final int KIND_CUSTOMATTRIBUTE = 2;
    public static final int KIND_OBJECTTYPECATEGORY = 3;
    public static final int DATATYPE_STRING_SINGLELINE = 1;
    public static final int DATATYPE_STRING_MULTILINE = 2;
    public static final int DATATYPE_BOOLEAN = 3;
    public static final int DATATYPE_DURATION = 5;
    public static final int DATATYPE_DATE = 6;
    public static final int DATATYPE_INTEGER = 7;
    public static final int DATATYPE_REAL = 8;
    public static final int DATATYPE_ENUM_EXTENDABLE = 9;
    public static final int DATATYPE_ENUM_SINGLE_FROMFRAME = 12;
    public static final int DATATYPE_ENUM_SINGLE = 10;
    public static final int DATATYPE_ENUM_MULTI = 11;
    public static final int DATATYPE_URL = 13;
    public static final int ENUMTYPE_NOTANENUM = -1;
    public static final int ENUMTYPE_DISCRETE = 0;
    public static final int ENUMTYPE_LINKED = 1;
    public static final int ENUMTYPE_LINKED_FROMFRAME = 3;
    public static final int ENUMTYPE_CUSTOM = 2;
    public static final int ENUMTYPE_OBJECTTYPECATEGORY = 4;
    private final ExistingAttributeReference key;
    private final Integer dataTypeKey;
    private final boolean isMandatory;
    private final String name;

    public TargetAttributeDescription(ExistingAttributeReference key, Integer dataTypeKey, boolean isMandatory, String name) {
        this.dataTypeKey = dataTypeKey;
        this.isMandatory = isMandatory;
        this.key = key;
        this.name = name;
    }

    public ExistingAttributeReference getKey() {
        return this.key;
    }

    public Integer getDataTypeKey() {
        return this.dataTypeKey;
    }

    public boolean isEnumType() {
        return this.dataTypeKey == 10 || this.dataTypeKey == 12 || this.dataTypeKey == 11 || this.dataTypeKey == 9;
    }

    public List<EnumValue<EnumValueReference>> getValueRange() {
        return this.determinePossibleValuesOfExistingEnumeration();
    }

    public boolean mayExtendValueRange() {
        int enumType = this.getEnumerationType();
        return enumType == 1 || enumType == 2;
    }

    public boolean isAttributeMandatory() {
        return this.isMandatory;
    }

    public boolean mayAttributeHaveMultipleMappings() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    private List<EnumValue<EnumValueReference>> determinePossibleValuesOfExistingEnumeration() {
        ArrayList<EnumValue<EnumValueReference>> possibleValues;
        block9: {
            int enumType;
            block12: {
                block11: {
                    block10: {
                        void var4_5;
                        block8: {
                            possibleValues = new ArrayList<EnumValue<EnumValueReference>>();
                            enumType = this.getEnumerationType();
                            if (enumType != 4) break block8;
                            possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(4, null), "", ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY, null));
                            for (ObjectTypeCategory category : this.key.getModelController().getProjectAgent().getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.key.getAttributeOwnersCockpitTypeID())) {
                                possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(4, category.getObjectTypeCategoryID()), category.getDisplayName(), null));
                            }
                            break block9;
                        }
                        if (enumType != 0) break block10;
                        ModuleDataAttributeDiscrete discreteAttribute = (ModuleDataAttributeDiscrete)this.key.getAttribute();
                        boolean bl = false;
                        while (var4_5 < discreteAttribute.getValueRange().length) {
                            possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(0, (int)var4_5), discreteAttribute.getValueRange()[var4_5].getName(this.key.getProjectLanguage()), null));
                            ++var4_5;
                        }
                        break block9;
                    }
                    if (enumType != 3) break block11;
                    ArrayList<IRepositoryObjectReference> linkableAttributeValues = new ArrayList<IRepositoryObjectReference>(this.key.getPlatformAccessAgent().getAllFrameDataItems(this.key.getLinkedFrameDataDataTypeID()));
                    Collections.sort(linkableAttributeValues, new Comparator<IRepositoryObjectReference>(){

                        @Override
                        public int compare(IRepositoryObjectReference ro1, IRepositoryObjectReference ro2) {
                            String label1 = null;
                            IExpiringFrontendLabel repositoryLabel1 = TargetAttributeDescription.this.key.getPlatformAccessAgent().getLabelForPlatformObject(ro1);
                            if (repositoryLabel1 != null) {
                                label1 = repositoryLabel1.getText();
                            }
                            String label2 = null;
                            IExpiringFrontendLabel repositoryLabel2 = TargetAttributeDescription.this.key.getPlatformAccessAgent().getLabelForPlatformObject(ro2);
                            if (repositoryLabel2 != null) {
                                label2 = repositoryLabel2.getText();
                            }
                            if (label1 == null && label2 == null) {
                                return 0;
                            }
                            if (label1 == null) {
                                return 1;
                            }
                            if (label2 == null) {
                                return -1;
                            }
                            return label1.compareToIgnoreCase(label2);
                        }
                    });
                    if (!this.isMandatory) {
                        possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(3, null), "", null));
                    }
                    for (IRepositoryObjectReference iRepositoryObjectReference : linkableAttributeValues) {
                        String label = this.key.getPlatformAccessAgent().getLabelForPlatformObject(iRepositoryObjectReference).getText();
                        possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(3, iRepositoryObjectReference), label, null));
                    }
                    break block9;
                }
                if (enumType != 1) break block12;
                ArrayList<? extends IModuleData> linkableAttributeValues = new ArrayList<IModuleData>(this.key.getModelController().getAllItems(this.key.getLinkedModuleDataDataTypeID()));
                Collections.sort(linkableAttributeValues, new Comparator<IModuleData>(){

                    @Override
                    public int compare(IModuleData md1, IModuleData md2) {
                        return md1.getDisplayRepresentation().compareToIgnoreCase(md2.getDisplayRepresentation());
                    }
                });
                if (!this.isMandatory) {
                    possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(1, ""), "", null));
                }
                for (IModuleData iModuleData : linkableAttributeValues) {
                    possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(1, iModuleData.getUID()), iModuleData.getDisplayRepresentation(), null));
                }
                break block9;
            }
            if (enumType != 2) break block9;
            if (!this.isMandatory) {
                possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(2, ""), "", null));
            }
            IValueRange customPropertyValueRange = this.key.getAttributeType().getValueRange();
            List list = (List)customPropertyValueRange.getValueRange();
            IAttributeTypeDataType customPropertyDataType = this.key.getAttributeType().getDataType();
            for (Object valueObject : list) {
                EnumerationEntry value = (EnumerationEntry)valueObject;
                String text = customPropertyDataType.getValueAsSingleLineString(Collections.singletonList(value), customPropertyValueRange, "", null);
                possibleValues.add((EnumValue<EnumValueReference>)new EnumValue((Object)new EnumValueReference(2, value.getID()), text, null));
            }
        }
        return possibleValues;
    }

    int getEnumerationType() {
        if (this.key.getAttributeKind() == 3 && this.dataTypeKey == 10) {
            return 4;
        }
        if (this.key.getAttributeKind() == 1 && this.dataTypeKey == 10) {
            return 0;
        }
        if (this.key.getAttributeKind() == 1 && this.dataTypeKey == 12) {
            return 3;
        }
        if (this.key.getAttributeKind() == 1 && this.dataTypeKey == 9) {
            return 1;
        }
        if (this.key.getAttributeKind() == 2 && this.dataTypeKey != 9) {
            return 2;
        }
        return -1;
    }

    public static Collection<IAttributeTypeDataType> getCustomPropertyDataTypesForExistingAttributeDataTypeID(int existingAttributeDataTypeID) {
        if (existingAttributeDataTypeID == 1) {
            return Arrays.asList(DataTypeString.getInstanceString());
        }
        if (existingAttributeDataTypeID == 2) {
            return Arrays.asList(DataTypeText.getInstanceText());
        }
        if (existingAttributeDataTypeID == 3) {
            return Arrays.asList(DataTypeBoolean.getSingleInstance());
        }
        if (existingAttributeDataTypeID == 13) {
            return Arrays.asList(DataTypeURL.getSingleInstance());
        }
        if (existingAttributeDataTypeID == 5) {
            return Arrays.asList(new IAttributeTypeDataType[0]);
        }
        if (existingAttributeDataTypeID == 6) {
            return Arrays.asList(DataTypeDate.getSingleInstance());
        }
        if (existingAttributeDataTypeID == 7) {
            return Arrays.asList(DataTypeInteger.getSingleInstance());
        }
        if (existingAttributeDataTypeID == 8) {
            return Arrays.asList(DataTypeDouble.getSingleInstance());
        }
        if (existingAttributeDataTypeID == 9) {
            return Arrays.asList(new IAttributeTypeDataType[0]);
        }
        if (existingAttributeDataTypeID == 12) {
            return Arrays.asList(new IAttributeTypeDataType[0]);
        }
        if (existingAttributeDataTypeID == 10) {
            return Arrays.asList(new DataTypeEnumerationSingle((IAttributeTypeDataType)DataTypeString.getInstanceString(), null), new DataTypeEnumerationSingle((IAttributeTypeDataType)DataTypeInteger.getSingleInstance(), null));
        }
        if (existingAttributeDataTypeID == 11) {
            return Arrays.asList(new DataTypeEnumerationMultiple((IAttributeTypeDataType)DataTypeString.getInstanceString(), null, false), new DataTypeEnumerationMultiple((IAttributeTypeDataType)DataTypeInteger.getSingleInstance(), null, false));
        }
        assert (false) : "Unknown existing attribute data type id: " + existingAttributeDataTypeID;
        return Collections.emptyList();
    }

    public static int getExistingAttributeDataTypeIDForCustomPropertyDataType(IAttributeTypeDataType attributeDataType) {
        int dataTypeID = attributeDataType instanceof DataTypeDouble ? 8 : (attributeDataType instanceof DataTypeBoolean ? 3 : (attributeDataType instanceof DataTypeDate ? 6 : (attributeDataType instanceof DataTypeInteger ? 7 : (attributeDataType instanceof DataTypeText ? 2 : (attributeDataType instanceof DataTypeString && !(attributeDataType instanceof DataTypeText) ? 1 : (attributeDataType instanceof DataTypeURL ? 13 : (attributeDataType instanceof DataTypeEnumerationMultiple ? 11 : (attributeDataType instanceof DataTypeEnumerationSingle ? 10 : -1))))))));
        return dataTypeID;
    }

    public static int getExistingAttributeDataTypeIDForModuleDataAttribute(IModuleDataAttribute attribute) {
        int dataTypeID;
        if (attribute instanceof ModuleDataAttributeString && ((ModuleDataAttributeString)attribute).getType() == 2) {
            dataTypeID = 2;
        } else if (attribute instanceof ModuleDataAttributeString || attribute instanceof ModuleDataAttributePath || attribute instanceof ModuleDataAttributeUser) {
            dataTypeID = 1;
        } else if (attribute instanceof ModuleDataAttributeDiscrete) {
            dataTypeID = 10;
        } else if (attribute instanceof ModuleDataAttributeBoolean) {
            dataTypeID = 3;
        } else if (attribute instanceof ModuleDataAttributeDuration) {
            dataTypeID = 5;
        } else if (attribute instanceof ModuleDataAttributeInteger || attribute instanceof ModuleDataAttributeLong) {
            dataTypeID = 7;
        } else if (attribute instanceof ModuleDataAttributeTimestamp) {
            dataTypeID = 6;
        } else {
            assert (false) : "Unknown module data attribute type: " + attribute.getClass().getName();
            dataTypeID = -1;
        }
        return dataTypeID;
    }
}

