/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardProvider;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.settings.global.IConfigurationManager;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportWizardDescription;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.ExportWizard;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportAdapter;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportableData;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExporterManager;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.importexport.ImportExportException;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractExporterManager
implements IWizardProvider,
IExporterManager {
    private static final ILogger logger = Logger.getLogger(AbstractExporterManager.class);
    private final Map<String, IExportAdapter> map_exporterID_exporterAdapter = new HashMap<String, IExportAdapter>();

    public AbstractExporterManager() {
        this.construct();
    }

    protected final void putExporter(String exporterID, IExportAdapter exportAdapter) {
        this.map_exporterID_exporterAdapter.put(exporterID, exportAdapter);
    }

    @Override
    public final ExportOrImportResult export(String projectUID, String exporterID, List<?> parameters, Collection<AbstractFilter> filters, IProgressDisplay monitor, Shell shell) {
        IExportAdapter exportAdapter = this.map_exporterID_exporterAdapter.get(exporterID);
        if (exportAdapter != null) {
            try {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                String configuration = null;
                if (exportAdapter.getConfigurationKey() != null) {
                    IConfigurationManager configurationManager = projectAgent.getConfigurationManager();
                    configuration = configurationManager.getConfigurationValue(exportAdapter.getConfigurationKey());
                }
                exportAdapter.startExport(parameters, configuration, PresentationContext.getVirtualMachineUserLocaleForNow(), monitor, shell);
                try {
                    IExportableData dataToBeExported = this.getDataToBeExported(projectUID, exporterID, filters, this.getModelControllerForProject(projectUID).getProjectLanguage());
                    exportAdapter.export(dataToBeExported, monitor, shell);
                }
                finally {
                    exportAdapter.closeExport(monitor, shell);
                }
                return new ExportOrImportResult(true, Messages.getString("AbstractExporterManager.ExportSuccessful"), exportAdapter.getOpenExportConfiguration());
            }
            catch (ExportOrImportFailedException e) {
                logger.error("Module export failed: " + exporterID, (Throwable)e);
                return new ExportOrImportResult(false, e.getMessageWithApplicationSemantics(), null);
            }
            catch (ImportExportException ieE) {
                logger.error("Module export failed (Repository exception): " + exporterID, (Throwable)ieE);
                String message = ieE.getLocalizedMessage() != null && ieE.getLocalizedMessage().trim().length() > 0 ? NLS.bind((String)Messages.getString("AbstractExporterManager.ExportFailed.WithExplanation"), (Object)ieE.getLocalizedMessage()) : Messages.getString("AbstractExporterManager.ExportFailed");
                return new ExportOrImportResult(false, message, null);
            }
            catch (Throwable e) {
                logger.error("Module export failed (unexpected failure): " + exporterID, e);
                return new ExportOrImportResult(false, Messages.getString("AbstractExporterManager.ExportFailed"), null);
            }
        }
        logger.error("Module exporter could not be found: " + exporterID);
        return new ExportOrImportResult(false, null, null);
    }

    public final List<ExportOrImportWizardDescription> getWizardDescriptions(Object selectedElement) {
        String projectUID;
        IModelController modelController;
        LinkedList<ExportOrImportWizardDescription> wizardDescriptions = new LinkedList<ExportOrImportWizardDescription>();
        if (selectedElement instanceof IProjectAgent && (modelController = this.getModelControllerForProject(projectUID = ((IProjectAgent)selectedElement).getProjectUID())) != null) {
            for (Map.Entry<String, IExportAdapter> entry : this.map_exporterID_exporterAdapter.entrySet()) {
                String exporterID = entry.getKey();
                IExportAdapter exportAdapter = entry.getValue();
                ExportWizard exportWizard = new ExportWizard(exporterID, exportAdapter.getWizardContribution(), exportAdapter.getConfigurationKey(), this, modelController, this.getFixAttributeFilterItems(projectUID), this.getCustomPropertyFilterDataTypes());
                exportWizard.init(null, (IStructuredSelection)new StructuredSelection(selectedElement));
                wizardDescriptions.add(new ExportOrImportWizardDescription(exporterID, (IWizard)exportWizard, exportAdapter.getWizardContribution()));
            }
        }
        return wizardDescriptions;
    }

    protected abstract void construct();

    protected abstract Collection<IFilterItem> getFixAttributeFilterItems(String var1);

    protected abstract Collection<String> getCustomPropertyFilterDataTypes();

    protected abstract IModelController getModelControllerForProject(String var1);

    protected abstract IExportableData getDataToBeExported(String var1, String var2, Collection<AbstractFilter> var3, Locale var4) throws ImportExportException;
}

