/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.gui.wizards.NoLicenseWizardPage;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.settings.global.IConfigurationManager;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExporterOrImporterSpecificWizardPage;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractExportAndImportWizardBase
extends Wizard
implements IExportWizard {
    private static final ILogger logger = Logger.getLogger(AbstractExportAndImportWizardBase.class);
    private static final int ASK_ID = -1;
    private static final String SETTINGS_MODULE_ID_MODULEIMPORTEXPORT = "modulelib2.importexportwizards";
    private final IModelController modelController;
    private final String exporterOrImporterID;
    private final IExportOrImportWizardContribution exportOrImportWizardContribution;
    private final String configurationKey;
    private List<IWizardPage> exporterOrImporterSpecificWizardPages;

    public AbstractExportAndImportWizardBase(String exporterOrImporterID, IExportOrImportWizardContribution exportWizardContribution, String configurationKey, IModelController modelController) {
        this.modelController = modelController;
        this.exporterOrImporterID = exporterOrImporterID;
        this.exportOrImportWizardContribution = exportWizardContribution;
        this.configurationKey = configurationKey;
    }

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.getTitle());
        this.setDefaultPageImageDescriptor(this.getImage());
        this.addPages();
    }

    public final void addPages() {
        IFrameProjectAgent projectAgent = (IFrameProjectAgent)this.modelController.getProjectAgent();
        IClientFunctionLicenseType2 requiredLicenseType = this.exportOrImportWizardContribution.getRequiredLicenseType();
        if (requiredLicenseType == null || projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)requiredLicenseType)) {
            for (IWizardPage page : this.getPagesForBeginning()) {
                this.addPage(page);
            }
            this.exporterOrImporterSpecificWizardPages = new LinkedList<IWizardPage>();
            IArcwayMemento exportOrImportSpecificSettings = this.getExportOrImportSpecificSettings(this.modelController, this.exporterOrImporterID);
            String exportOrImportSpecificConfiguration = null;
            if (this.configurationKey != null) {
                exportOrImportSpecificConfiguration = AbstractExportAndImportWizardBase.getExportOrImportSpecificConfiguration(this.modelController, this.configurationKey);
            }
            for (IWizardPage page : this.exportOrImportWizardContribution.getExporterOrImporterSpecificWizardPages(exportOrImportSpecificConfiguration)) {
                IArcwayMemento pageSpecificSettings;
                if (page instanceof IExporterOrImporterSpecificWizardPage && (pageSpecificSettings = exportOrImportSpecificSettings.getChild(((IExporterOrImporterSpecificWizardPage)page).getKey())) != null) {
                    ((IExporterOrImporterSpecificWizardPage)page).readSettings(pageSpecificSettings);
                }
                this.addPage(page);
                this.exporterOrImporterSpecificWizardPages.add(page);
            }
            for (IWizardPage page : this.getPagesForEnd()) {
                this.addPage(page);
            }
        } else {
            NoLicenseWizardPage noLicenseWizardPage = new NoLicenseWizardPage("\"" + this.exportOrImportWizardContribution.getName() + "\"", (IClientFunctionLicenseType)requiredLicenseType);
            this.addPage((IWizardPage)noLicenseWizardPage);
        }
    }

    public boolean performFinish() {
        IArcwayMemento exportOrImportSpecificSettings = this.getExportOrImportSpecificSettings(this.modelController, this.exporterOrImporterID);
        final LinkedList<Object> parameters = new LinkedList<Object>();
        for (IWizardPage page : this.exporterOrImporterSpecificWizardPages) {
            if (!(page instanceof IExporterOrImporterSpecificWizardPage)) continue;
            if (page instanceof IExporterOrImporterSpecificWizardPage) {
                IArcwayMemento pageSpecificSettings = exportOrImportSpecificSettings.getChild(((IExporterOrImporterSpecificWizardPage)page).getKey());
                if (pageSpecificSettings == null) {
                    pageSpecificSettings = exportOrImportSpecificSettings.createChild(((IExporterOrImporterSpecificWizardPage)page).getKey());
                }
                ((IExporterOrImporterSpecificWizardPage)page).storeSettings(pageSpecificSettings);
            }
            parameters.add(((IExporterOrImporterSpecificWizardPage)page).getParameter());
        }
        final Shell shell = this.getShell();
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ExportOrImportResult result = AbstractExportAndImportWizardBase.this.doExportOrImport(AbstractExportAndImportWizardBase.this.modelController.getProjectUID(), parameters, (IProgressDisplay)new JFaceProgressMonitorToProgressDisplayAdapter(monitor));
                if (!result.isSuccessful()) {
                    String message = result.getMessage();
                    if (message == null || message.length() == 0) {
                        message = AbstractExportAndImportWizardBase.this.getExportOrImportFailedMessageDialogueDefaultText();
                    }
                    MessageDialog.openError((Shell)shell, (String)AbstractExportAndImportWizardBase.this.getExportOrImportFailedMessageDialogueTitle(), (String)message);
                } else {
                    int openExport;
                    String message;
                    String title;
                    if (result.getMessage() != null) {
                        title = Messages.getString("AbstractImporterManager.ExportOrImportInformationMessageTitle");
                        message = result.getMessage();
                    } else {
                        title = AbstractExportAndImportWizardBase.this.getExportOrImportSucceededMessageDialogueTitle();
                        message = AbstractExportAndImportWizardBase.this.getExportOrImportSucceededMessageDialogueDefaultText();
                    }
                    String preferenceStoreKey = null;
                    if (result.getResultMessageConfiguration() != null) {
                        preferenceStoreKey = result.getResultMessageConfiguration().getConfigurationPropertyForOpenExportBehaviour();
                        String askUser = FramePlugin.getDefault().getPreferenceStore().getString(preferenceStoreKey);
                        openExport = askUser.equals("always") ? 2 : (askUser.equals("never") ? 3 : -1);
                    } else {
                        openExport = 3;
                    }
                    if (openExport == 3) {
                        MessageDialog.open((int)2, (Shell)shell, (String)title, (String)message, (int)16384);
                    } else {
                        if (openExport == -1) {
                            MessageDialogWithToggle askDialog = MessageDialogWithToggle.open((int)3, (Shell)shell, (String)title, (String)result.getResultMessageConfiguration().getMessage(), (String)Messages.getString("Export.OpenExportDialogue.RememberDecisionMessage"), (boolean)false, (IPreferenceStore)FramePlugin.getDefault().getPreferenceStore(), (String)preferenceStoreKey, (int)16384);
                            openExport = askDialog.getReturnCode();
                        }
                        if (openExport == 2) {
                            UrlLauncher.launchFile_noEx((File)result.getResultMessageConfiguration().getFileToBeOpened(), null);
                        }
                    }
                }
            }
        };
        try {
            pmd.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn("Exception during import or export", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.warn("Exception during import or export", (Throwable)e);
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    protected IArcwayMemento getExportOrImportSpecificSettings(IModelController modelController_, String exporterOrImporterID_) {
        IArcwayMemento localSettingsStore = modelController_.getProjectAgent().getLocalSettings(SETTINGS_MODULE_ID_MODULEIMPORTEXPORT);
        IArcwayMemento exportOrImportSpecificSettings = localSettingsStore.getChild(exporterOrImporterID_);
        if (exportOrImportSpecificSettings == null) {
            exportOrImportSpecificSettings = localSettingsStore.createChild(exporterOrImporterID_);
        }
        return exportOrImportSpecificSettings;
    }

    private static String getExportOrImportSpecificConfiguration(IModelController modelController_, String configurationKey_) {
        IConfigurationManager configurationManager = modelController_.getProjectAgent().getConfigurationManager();
        String configuration = configurationManager.getConfigurationValue(configurationKey_);
        return configuration;
    }

    protected abstract String getTitle();

    protected abstract ImageDescriptor getImage();

    protected abstract List<IWizardPage> getPagesForBeginning();

    protected abstract List<IWizardPage> getPagesForEnd();

    protected abstract String getExportOrImportFailedMessageDialogueTitle();

    protected abstract String getExportOrImportFailedMessageDialogueDefaultText();

    protected abstract String getExportOrImportSucceededMessageDialogueTitle();

    protected abstract String getExportOrImportSucceededMessageDialogueDefaultText();

    protected abstract ExportOrImportResult doExportOrImport(String var1, List<?> var2, IProgressDisplay var3);
}

