/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.core.links.ILinkModificationListener;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;

public abstract class VersionLinkModificationListener
implements ILinkModificationListener {
    private final IModel dataMgr;

    public void linksAdded(final Collection<EOLink> links) {
        this.dataMgr.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (EOLink link : links) {
                    VersionLinkModificationListener.this.linkAdded(link);
                }
            }
        });
    }

    public void linksDeleted(final Collection<EOLink> links) {
        this.dataMgr.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (EOLink link : links) {
                    VersionLinkModificationListener.this.linkDeleted(link);
                }
            }
        });
    }

    public VersionLinkModificationListener(IModel dataMgr) {
        this.dataMgr = dataMgr;
    }

    public void linkAdded(EOLink link) {
        this.handleLinkModification(link);
    }

    public void linkDeleted(EOLink link) {
        this.handleLinkModification(link);
    }

    protected void handleLinkModification(EOLink link) {
        IModuleData item;
        if (!this.dataMgr.isImportRunning() && (item = this.extractItem(link)) != null) {
            this.dataMgr.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    VersionLinkModificationListener.this.dataMgr.itemPropertiesModified(item, false);
                }
            });
        }
    }

    protected abstract IModuleData extractItem(EOLink var1);

    public boolean informDuringServerUpdate() {
        return false;
    }
}

