/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IModuleStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionMgr;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.INewIDReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.core.project.ModelModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.core.project.ModulePlatformAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public abstract class ModelController
implements IModelController {
    private IModel modelMgr;
    private AbstractPermissionMgr permissionMgr;
    private AbstractLockManager lockMgr;
    private ProjectionMgr projectionMgr;
    private LinkMgr linkMgr;
    private IDataFacade dataFacade;
    private String projectUID;
    private IModuleProjectAgent frameProjectAgent;
    private PropertyChangesManager propertyChangesManager;
    private ModulePlatformAccess platformAccessAgent;
    private IClientDataFactory clientDataFactory;
    private ILinkTypeHelper_Shared linkTypeHelper;
    private IUIDataTypesHelper uiDataTypesHelper;
    private static final ILogger logger = Logger.getLogger(ModelController.class);

    public void construct(IModel modelMgrP, AbstractPermissionMgr permissionMgrP, AbstractLockManager lockMgrP, ProjectionMgr projectionMgrP, LinkMgr linkMgrP, PropertyChangesManager propertyChangesManager_, IDataFacade dataFacade_, String projectUIDP, IModuleProjectAgent frameProjectAgent_, IClientDataFactory clientDataFactory_, ILinkTypeHelper_Shared linkTypeHelper_, IUIDataTypesHelper uiDataTypesHelper_, ModulePlatformAccess platformAccessAgent_) {
        this.modelMgr = modelMgrP;
        this.permissionMgr = permissionMgrP;
        this.lockMgr = lockMgrP;
        this.projectionMgr = projectionMgrP;
        this.linkMgr = linkMgrP;
        this.dataFacade = dataFacade_;
        this.projectUID = projectUIDP;
        this.frameProjectAgent = frameProjectAgent_;
        this.propertyChangesManager = propertyChangesManager_;
        this.clientDataFactory = clientDataFactory_;
        this.linkTypeHelper = linkTypeHelper_;
        this.uiDataTypesHelper = uiDataTypesHelper_;
        this.platformAccessAgent = platformAccessAgent_;
    }

    @Override
    public String getProjectUID() {
        return this.projectUID;
    }

    @Override
    public void addItem(IModuleData item) {
        assert (item != null);
        this.modelMgr.addItem(item, true);
    }

    @Override
    public IModuleData deleteItem(IModuleData item) {
        assert (item != null);
        IModuleData removedItem = this.modelMgr.removeItem(item);
        return removedItem;
    }

    @Override
    public void deleteItems(Collection<? extends IModuleData> items) {
        this.modelMgr.removeItems(items);
    }

    @Override
    public void undoItemCreation(Collection<? extends IModuleData> createdItems, Collection<EOLink> createdLinks) {
        this.modelMgr.undoItemCreation(createdItems, createdLinks);
    }

    @Override
    public void itemPropertiesModified(IModuleData item, String[] properties) {
        assert (item != null);
        this.modelMgr.itemPropertiesModified(item);
    }

    @Override
    public void itemPropertiesModified(IModuleData[] items, String[] properties) {
        if (items.length > 0) {
            assert (this.areOfSameClass(items));
            Class<?> itemClass = items[0].getClass();
            this.modelMgr.itemPropertiesModified(items);
            PropertyChanges changes = new PropertyChanges(null, Arrays.asList(items), null);
            this.frameProjectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, itemClass);
        }
    }

    private boolean areOfSameClass(IModuleData[] items) {
        Class<?> clazz = null;
        IModuleData[] iModuleDataArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleData item = iModuleDataArray[n2];
            Class<?> itemClass = item.getClass();
            if (clazz == null) {
                clazz = itemClass;
            } else if (!clazz.isAssignableFrom(itemClass) || !itemClass.isAssignableFrom(clazz)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public IModuleData getItem(String dataTypeUID, String itemUID) {
        assert (dataTypeUID != null);
        assert (itemUID != null);
        return this.modelMgr.getItem(dataTypeUID, itemUID);
    }

    @Override
    public IModuleData getItemByID(String dataTypeUID, String id) {
        assert (dataTypeUID != null);
        assert (id != null);
        return this.modelMgr.getItemByID(dataTypeUID, id);
    }

    @Override
    public Collection<? extends IModuleData> getAllItems(String dataTypeUID) {
        assert (dataTypeUID != null);
        return this.modelMgr.getAllItems(dataTypeUID);
    }

    @Override
    public List<? extends IModuleData> getVersionsOfItem(IModuleData item) {
        assert (item != null);
        return this.modelMgr.getVersionsOfItem(item);
    }

    @Override
    public AbstractPermissionMgr getPermissionMgr() {
        return this.permissionMgr;
    }

    @Override
    public AbstractLockManager getLockMgr() {
        assert (this.lockMgr != null) : "lockMgr must not be null";
        return this.lockMgr;
    }

    @Override
    public PropertyChangesManager getPropertyChangesManager() {
        return this.propertyChangesManager;
    }

    @Override
    public ModulePlatformAccess getPlatformAccessAgent() {
        return this.platformAccessAgent;
    }

    @Override
    public IStatus createLink(String linkableObjectUID, String moduleDataUID, String linkTypeID) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - createLink");
        }
        return this.linkMgr.createLink(linkableObjectUID, moduleDataUID, linkTypeID);
    }

    @Override
    public IStatus createLink(String linkableObjectUID, IModuleData moduleDataItem, String linkTypeID) {
        return this.createLink(linkableObjectUID, moduleDataItem.getUID(), linkTypeID);
    }

    public Collection createLinks(Collection linkableObjects, IModuleData moduleDataItem, String linkTypeID) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - createLinks");
        }
        return this.linkMgr.createLinks(linkableObjects, moduleDataItem, linkTypeID);
    }

    public Collection createLinks(String linkableObjectUID, Collection moduleData, String linkTypeID) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - createLinks");
        }
        return this.linkMgr.createLinks(linkableObjectUID, moduleData, linkTypeID);
    }

    @Override
    public IStatus deleteLink(EOLink link) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - deleteLink");
        }
        return this.linkMgr.deleteLink(link);
    }

    @Override
    public IStatus deleteLink(String linkableObjectUID, String moduleDataItemUID, String linkTypeID) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - deleteLink");
        }
        return this.linkMgr.deleteLink(linkableObjectUID, moduleDataItemUID, linkTypeID);
    }

    public Collection getLinkableObjects(IModuleData moduleDataItem, String linkTypeID) {
        return this.modelMgr.getLinkableObjects(moduleDataItem, linkTypeID);
    }

    public Collection getModuleData(String linkableObjectUID, String linkTypeID) {
        return this.modelMgr.getModuleData(linkableObjectUID, linkTypeID);
    }

    public Collection getModuleData(String linkableObjectUID, int modCount, String linkTypeID) {
        return this.modelMgr.getModuleData(linkableObjectUID, modCount, linkTypeID);
    }

    @Override
    public Set<EOLink> getLinksForLinkableObject(String linkableObjectUID, String linkTypeID) {
        return this.linkMgr.getLinksForLinkableObject(linkableObjectUID, linkTypeID);
    }

    @Override
    public Set<? extends EOLink> getLinksForLinkableObject(IModuleData linkableObject, String linkTypeID) {
        return this.linkMgr.getLinksForLinkableObject(linkableObject, linkTypeID);
    }

    @Override
    public Set<? extends EOLink> getLinksForModuleDataItem(IModuleData data, String linkTypeID) {
        return this.linkMgr.getLinksForModuleDataItem(data, linkTypeID);
    }

    @Override
    public boolean linkExists(String linkableObject, IModuleData moduleDataItem, String linkTypeID) {
        return this.linkMgr.linkExists(this.getProjectAgent().getProjectUID(), linkableObject, moduleDataItem, linkTypeID);
    }

    @Override
    public IModuleData getParent(IModuleData item) {
        return this.modelMgr.getParent(item);
    }

    @Override
    public Collection<IModuleData> getChildren(IModuleData item) {
        return this.modelMgr.getChildren(item);
    }

    @Override
    public Collection<IModuleData> getChildren(IModuleData item, String dataTypeID) {
        return this.modelMgr.getChildren(item, dataTypeID);
    }

    public Collection getAllDescendants(IModuleData item) {
        return this.modelMgr.getAllDescendants(item);
    }

    @Override
    public Section getSection(IModuleData rootItem) {
        return this.modelMgr.getSection(rootItem);
    }

    @Override
    public void setSection(IModuleData rootItem, Section section) {
        this.modelMgr.setSection(rootItem, section);
    }

    @Override
    public Object getInput() {
        return this.modelMgr.getAllRootItems();
    }

    public Collection getAllRootItems() {
        return this.modelMgr.getAllRootItems();
    }

    public Collection getRootItems(String cockpitTypeID) {
        return this.modelMgr.getRootItems(cockpitTypeID);
    }

    @Override
    public String getModuleDataDataTypeIDforLinkType(String linkType) {
        return this.getLinkTypeHelper().getLinkSourceDataTypeIDForLinkType(linkType);
    }

    @Override
    public String getLinkableObjectDataTypeUIDforLinkType(String linkType) {
        return this.getLinkTypeHelper().getLinkTargetDataTypeIDForLinkType(linkType);
    }

    protected IModel getModel() {
        return this.modelMgr;
    }

    @Override
    public IProjectionMgr getProjectionManager() {
        return this.projectionMgr;
    }

    @Override
    public IDataFacade getDataFacade() {
        return this.dataFacade;
    }

    public List filterSelection(List selection) {
        return this.modelMgr.filterSelection(selection);
    }

    public Collection getModuleData(IModuleData linkableObject, String linkTypeID) {
        return this.modelMgr.getModuleData(linkableObject, linkTypeID);
    }

    @Override
    public boolean itemExists(String dataTypeUID, String itemUID) {
        return this.modelMgr.itemExists(itemUID, dataTypeUID);
    }

    @Override
    public void executeTransaction(Runnable todo) {
        this.frameProjectAgent.getModelTransactionManager().executeTransaction(todo);
    }

    private boolean isInTransaction() {
        return this.frameProjectAgent.getModelTransactionManager().isInTransaction();
    }

    @Override
    public IModuleStakeholderManager getStakeHolderManager() {
        return this.modelMgr.getStakeholderManager();
    }

    @Override
    public Collection<IModuleData> getAllVisibleItems() {
        HashSet<IModuleData> visibleItems = new HashSet<IModuleData>();
        for (String dataTypeID : this.getDataTypesHelper().getDocumentationDataTypes()) {
            if (!this.getUIDataTypesHelper().isToBeShownInDataView(dataTypeID)) continue;
            visibleItems.addAll(this.getAllItems(dataTypeID));
        }
        return visibleItems;
    }

    @Override
    public Collection<? extends IModuleData> getAllAscendants(IModuleData item) {
        return this.modelMgr.getAllAscendants(item);
    }

    @Override
    public void projectClosed() {
        this.modelMgr.projectClosed();
    }

    public Collection addLinks(Collection links, String linkType) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - addLinks");
        }
        return this.linkMgr.addLinks(links, linkType);
    }

    public Collection deleteLinks(Collection linkableObjects, IModuleData moduleDataItem, String linkType) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - deleteLinks");
        }
        return this.linkMgr.deleteLinks(linkableObjects, moduleDataItem, linkType);
    }

    public Collection deleteLinks(String linkableObjectUID, Collection moduleData, String linkType) {
        if (!this.isInTransaction()) {
            logger.warn("transactionParenthesisCount < 1 - deleteLinks");
        }
        return this.linkMgr.deleteLinks(linkableObjectUID, moduleData, linkType);
    }

    @Override
    public IModuleProjectAgent getProjectAgent() {
        return this.modelMgr.getProjectAgent();
    }

    @Override
    public Locale getProjectLanguage() {
        return this.modelMgr.getProjectLanguage();
    }

    @Override
    public boolean assertIDIsSet(IModuleData item) {
        return this.modelMgr.assertIDIsSet(item);
    }

    @Override
    public boolean hasExistingID(IModuleData item) {
        return this.modelMgr.hasExistingID(item);
    }

    @Override
    public boolean hasExistingName(IModuleData item, IModuleData parent) {
        return this.modelMgr.hasExistingName(item, parent);
    }

    @Override
    public String getIDPrefix(IModuleData moduleData, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        return ((AbstractDataMgr)this.modelMgr).getIDPrefix(moduleData, dataTypeOfItemToBeCreated);
    }

    @Override
    public String generateNewID(IModuleDataTypeDescription itemTypeDescription, int idType, IModuleData parent, boolean acquireLock, LockAccessWrapper lockAccessWrapper) throws EXCockpitLockDenied {
        return this.modelMgr.generateNewID(itemTypeDescription, idType, parent, acquireLock, lockAccessWrapper);
    }

    public String generateNewID(int idType, String prefix, String separator, Object incrementParameter, Collection existingItems, String idAttributeRoleID, boolean acquireLock, String idTypeForLocking, LockAccessWrapper lockAccessWrapper) throws EXCockpitLockDenied {
        return this.modelMgr.generateNewID(idType, prefix, separator, incrementParameter, existingItems, idAttributeRoleID, acquireLock, idTypeForLocking, lockAccessWrapper);
    }

    @Override
    public void generateNewIDs(CollectionMap<IModuleData, INewIDReceiver> map_parent_idReceivers, IModuleDataTypeDescription itemTypeDescription, int idType, boolean acquireLock, boolean reserveIDTemporarily) throws EXCockpitLockDenied {
        this.modelMgr.generateNewIDs(map_parent_idReceivers, itemTypeDescription, idType, acquireLock, reserveIDTemporarily);
    }

    @Override
    public String generateNewName(IModuleData item, IModuleData parent, boolean acquireLock, LockAccessWrapper lockAccessWrapper) {
        return this.modelMgr.generateNewName(item, parent, acquireLock, lockAccessWrapper);
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, IModuleData_CustomPropertiesExtension moduleData, IAttributeType attributeType) {
        this.modelMgr.modifyAttribute(newAttribute, moduleData, attributeType);
    }

    @Override
    public boolean isNew(ICockpitProjectData item) {
        return this.modelMgr.isNew(item);
    }

    @Override
    public boolean isModified(ICockpitProjectData item) {
        return this.modelMgr.isModified(item);
    }

    @Override
    public boolean isDeleted(ICockpitProjectData item) {
        return this.modelMgr.isDeleted(item);
    }

    @Override
    public void movedItems(Map<IModuleData, IModuleData> movedItemsWithOldParents, IModuleData newParent) {
        for (Map.Entry<IModuleData, IModuleData> singleMovedItemEntry : movedItemsWithOldParents.entrySet()) {
            IModuleData movedItem = singleMovedItemEntry.getKey();
            IModuleData oldParent = singleMovedItemEntry.getValue();
            IModuleDataTypeDescriptionForFrame naturalOrderDataType = movedItem.getTypeDescription().getDataTypeForNaturalOrdering();
            if (naturalOrderDataType == null) continue;
            this.frameProjectAgent.getSequencerManager().objectMoved((ICockpitProjectData)movedItem, (ICockpitProjectData)oldParent, (ICockpitProjectData)newParent, naturalOrderDataType.getCockpitDataTypeID());
        }
    }

    @Override
    public void reorderedItems(Collection<IModuleData> reorderedItems, IModuleData parent) {
    }

    @Override
    public AbstractModuleAttributeAgent getAttributeOwner(IModuleData data) {
        return new ModelModuleAttributeAgent(data, this.getProjectAgent().getModuleUserDefinedAttributeTypesManager(), this.getModel());
    }

    @Override
    public AbstractModuleAttributeAgent getAttributeModificationManager(IModuleData data) {
        return this.getAttributeOwner(data);
    }

    @Override
    public IDataTypesHelper getDataTypesHelper() {
        return this.getModel().getDataTypesHelper();
    }

    @Override
    public IUIDataTypesHelper getUIDataTypesHelper() {
        return this.uiDataTypesHelper;
    }

    @Override
    public IClientDataFactory getClientDataFactory() {
        return this.clientDataFactory;
    }

    @Override
    public ILinkTypeHelper_Shared getLinkTypeHelper() {
        return this.linkTypeHelper;
    }

    public boolean equals(Object arg0) {
        return arg0 instanceof ModelController && this.getProjectUID().equals(((ModelController)arg0).getProjectUID()) && this.getModuleID().equals(((ModelController)arg0).getModuleID());
    }

    public int hashCode() {
        return this.getProjectUID().hashCode() ^ this.getModuleID().hashCode();
    }
}

