/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.frame.client.project.datainterchange.FrameImportExportManager;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.modules.IExportDataProvider;
import com.arcway.cockpit.frame.client.project.modules.IImportDataAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.shared.message.IncompatibleDataTypeException;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.gui.ISubActivityProgressManager;
import de.plans.lib.xml.encoding.EOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ExportDataProvider
implements IExportDataProvider,
IImportDataAgent {
    private static final ILogger logger = Logger.getLogger(ExportDataProvider.class);
    private IModuleProjectAgent projectAgent;
    protected IModel modelManager;
    private IDataTypesHelper dataTypesHelper;
    private IClientDataFactory clientDataFactory;
    private final boolean isSavingDisabled = false;
    private int importsInProgress = 0;

    public void construct(IClientDataFactory clientDataFactory_, IModuleProjectAgent projectAgent_, IModel modelManager_) {
        assert (projectAgent_ != null);
        this.projectAgent = projectAgent_;
        this.modelManager = modelManager_;
        this.dataTypesHelper = modelManager_.getDataTypesHelper();
        this.clientDataFactory = clientDataFactory_;
    }

    public EOList<EOModuleData> getExportList(String moduleDataTypeID) {
        Collection<? extends IModuleData> allItems = this.modelManager.getAllItems(moduleDataTypeID);
        Collection<? extends IModuleData> preparedItems = this.checkItemsBeforeExport(allItems, moduleDataTypeID);
        EOList data = new EOList(ExportDataProvider.convertToListOfEOs(preparedItems));
        data.setRole(moduleDataTypeID);
        return data;
    }

    protected abstract Collection<? extends IModuleData> checkItemsBeforeExport(Collection<? extends IModuleData> var1, String var2);

    public boolean supportsDataType(EOList<?> importData) {
        return this.dataTypesHelper.getAllTrueDataTypes().contains(importData.getRole());
    }

    public Map<Object, Object> importDataAsLocalModification(EOList<?> data, boolean generateNewUIDs, ISubActivityProgressManager progressManager, FrameImportExportManager.FileImporter fileImporter) throws ProjectFileAccess.ProjectFileAccessException {
        progressManager.setNumberOfSteps(2);
        progressManager.startNextStep();
        ExportDataProvider.callImportManagerCallbackForFileAttributes(data, fileImporter);
        Tuple<Collection<IModuleData>, Map<Object, Object>> preparationResult = this.prepareImport(data, generateNewUIDs);
        ISubActivityProgressManager subProgressManager = progressManager.startNextStep();
        this.addAllItems(data.getRole(), (Collection)preparationResult.getT1(), subProgressManager);
        return (Map)preparationResult.getT2();
    }

    private static void callImportManagerCallbackForFileAttributes(EOList<?> data, FrameImportExportManager.FileImporter fileImporter) {
        for (Object md : data) {
            if (!(md instanceof EOModuleData)) continue;
            EOModuleData eoModuleData = (EOModuleData)md;
            EOList customAttributes = eoModuleData.getCustomAttributes();
            for (Object ca : customAttributes) {
                if (!(ca instanceof EOAttribute)) continue;
                EOAttribute eoAttribute = (EOAttribute)ca;
                fileImporter.handleFileAttribute(eoAttribute);
            }
        }
    }

    private Tuple<Collection<IModuleData>, Map<Object, Object>> prepareImport(EOList<?> importData, boolean generateNewUIDs) {
        List<IModuleData> moduleData = this.convertFromListOfEOs((Collection<?>)importData);
        HashMap<Object, Object> replacementMap = new HashMap<Object, Object>();
        Collection<IModuleData> preparedModuleData = this.checkItemsBeforeImport(moduleData, replacementMap, generateNewUIDs);
        return new Tuple(preparedModuleData, replacementMap);
    }

    private Collection<IModuleData> checkItemsBeforeImport(Collection<IModuleData> items, Map<Object, Object> replacementMap, boolean generateNewUIDs) {
        ArrayList<IModuleData> itemsToBeImported = new ArrayList<IModuleData>();
        for (IModuleData item : items) {
            IModuleData newItem = this.checkItemBeforeImport(item, replacementMap, generateNewUIDs);
            if (newItem == null) continue;
            itemsToBeImported.add(newItem);
        }
        return itemsToBeImported;
    }

    protected abstract IModuleData checkItemBeforeImport(IModuleData var1, Map<Object, Object> var2, boolean var3);

    protected void addAllItems(final String dataTypeId, final Collection<IModuleData> data, final ISubActivityProgressManager progressManager) throws ProjectFileAccess.ProjectFileAccessException {
        ProjectFileAccess.ProjectFileAccessException[] exceptionWrapper = new ProjectFileAccess.ProjectFileAccessException[1];
        this.modelManager.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                progressManager.setNumberOfSteps(data.size());
                String projectUID = ExportDataProvider.this.projectAgent.getProjectUID();
                for (IModuleData moduleData : data) {
                    IModuleData existingItem;
                    block4: {
                        progressManager.startNextStep();
                        moduleData.setProjectUID(projectUID);
                        existingItem = ExportDataProvider.this.modelManager.getItem(dataTypeId, moduleData.getUID());
                        if (existingItem == null) {
                            ExportDataProvider.this.modelManager.addItem(moduleData, false);
                            continue;
                        }
                        try {
                            existingItem.copyDataFrom((AbstractModuleData)moduleData, true);
                        }
                        catch (IncompatibleDataTypeException idtE) {
                            if ($assertionsDisabled) break block4;
                            throw new AssertionError((Object)"Copying data from module data object of wrong type.");
                        }
                    }
                    ExportDataProvider.this.modelManager.itemPropertiesModified(existingItem);
                }
            }
        });
        if (exceptionWrapper[0] != null) {
            throw exceptionWrapper[0];
        }
    }

    private static List<EOModuleData> convertToListOfEOs(Collection<? extends IModuleData> items) {
        assert (items != null);
        ArrayList<EOModuleData> listOfEOs = new ArrayList<EOModuleData>();
        for (IModuleData iModuleData : items) {
            listOfEOs.add(iModuleData.createEncodableObject());
        }
        return listOfEOs;
    }

    private List<IModuleData> convertFromListOfEOs(Collection<?> items) {
        assert (items != null);
        ArrayList<IModuleData> listOfModuleDatas = new ArrayList<IModuleData>();
        for (Object element : items) {
            assert (element instanceof EOModuleData);
            if (!(element instanceof EOModuleData)) continue;
            listOfModuleDatas.add(this.clientDataFactory.convertFromEO((EOModuleData)element, this.projectAgent.getUID()));
        }
        return listOfModuleDatas;
    }

    protected static final IModuleData copyItemAndReplaceUid(IModuleData item, boolean generateNewUIDs) {
        return item.copy(!generateNewUIDs);
    }

    public void importFinished() {
        --this.importsInProgress;
        this.modelManager.stopImport();
    }

    public void importStarted() {
        ++this.importsInProgress;
        this.modelManager.startImport();
    }

    protected void finalize() {
        if (this.importsInProgress != 0) {
            logger.warn("(BeginImport - EndImports) == " + this.importsInProgress + "; should be 0!");
        }
    }
}

