/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client;

import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.lib.extensioning.IPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractModulePlugin
extends AbstractUIPlugin
implements IPlugin {
    private static final String ICON_PATH = "icons/";
    private static final String SPEC_PATH = "spec/";
    private ProjectMgr projectMgr;
    private ImageDescriptorRegistry imageDescriptorRegistry;

    public ProjectMgr getProjectManager() {
        if (this.projectMgr == null) {
            this.projectMgr = new ProjectMgr();
        }
        return this.projectMgr;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public ImageDescriptor getImageDescriptor_(String fileName) {
        ImageDescriptor desc;
        String iconPath = this.getIconPath();
        try {
            URL installURL = this.getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + fileName);
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            desc = null;
        }
        return desc;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.imageDescriptorRegistry != null) {
                this.imageDescriptorRegistry.dispose();
            }
        }
        finally {
            super.stop(context);
        }
    }

    public String getPluginID() {
        return this.getBundle().getSymbolicName();
    }

    public final String getPluginResourceString(String key) {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)this.getBundle());
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getIconPath() {
        return ICON_PATH;
    }

    public String getSpecPath() {
        return SPEC_PATH;
    }
}

