/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.issuemodule1migrator.core.messages;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public abstract class EOIssueContainer
extends EOEncodableObject {
    private static final String ROLE_ACTION_ITEMS = "issues";
    private static final String ROLE_ACTION_ITEM_REMARKS = "notes";
    private static final String ROLE_UE_LINKS = "ueLinks";
    private static final String ROLE_LE_LINKS = "leLinks";
    protected EOList issues;
    protected EOList uniqueElementLinks;
    protected EOList localElementLinks;
    protected EOList notes;

    public EOIssueContainer(String xmlName) {
        this(xmlName, new EOList(ROLE_ACTION_ITEMS), new EOList(ROLE_ACTION_ITEM_REMARKS), new EOList(ROLE_LE_LINKS), new EOList(ROLE_UE_LINKS));
    }

    public EOIssueContainer(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
        this.init(new EOList(ROLE_ACTION_ITEMS), new EOList(ROLE_ACTION_ITEM_REMARKS), new EOList(ROLE_LE_LINKS), new EOList(ROLE_UE_LINKS));
    }

    public EOIssueContainer(String xmlName, EOList issues, EOList notes, EOList localElementLinks, EOList uniqueElementLinks) {
        super(xmlName);
        this.init(issues, notes, localElementLinks, uniqueElementLinks);
    }

    public void init(EOList issuesInit, EOList notesInit, EOList localElementLinksInit, EOList uniqueElementLinksInit) {
        assert (issuesInit != null);
        assert (localElementLinksInit != null);
        assert (uniqueElementLinksInit != null);
        assert (notesInit != null);
        this.issues = issuesInit;
        this.localElementLinks = localElementLinksInit;
        this.uniqueElementLinks = uniqueElementLinksInit;
        this.notes = notesInit;
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean knownAttribute = true;
        if (newChild.getTag().equals("List")) {
            EOList list = (EOList)newChild;
            if (ROLE_ACTION_ITEMS.equals(list.getRole())) {
                this.issues = list;
            } else if (ROLE_ACTION_ITEM_REMARKS.equals(list.getRole())) {
                this.notes = list;
            } else if (ROLE_UE_LINKS.equals(list.getRole())) {
                this.uniqueElementLinks = list;
            } else if (ROLE_LE_LINKS.equals(list.getRole())) {
                this.localElementLinks = list;
            } else {
                knownAttribute = false;
            }
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    protected boolean setAttributeFromXML(String name, String value) {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.issues.writeXMLBody(writeContext, depth);
        this.notes.writeXMLBody(writeContext, depth);
        this.uniqueElementLinks.writeXMLBody(writeContext, depth);
        this.localElementLinks.writeXMLBody(writeContext, depth);
    }

    public EOList getIssues() {
        return this.issues;
    }

    public EOList getLocalElements() {
        return this.localElementLinks;
    }

    public EOList getUniqueElements() {
        return this.uniqueElementLinks;
    }

    public EOList getNotes() {
        return this.notes;
    }

    public void setIssues(EOList list) {
        assert (list != null);
        list.setRole(ROLE_ACTION_ITEMS);
        this.issues = list;
    }

    public void setLocalElementLinks(EOList list) {
        assert (list != null);
        list.setRole(ROLE_LE_LINKS);
        this.localElementLinks = list;
    }

    public void setUniqueElementLinks(EOList list) {
        assert (list != null);
        list.setRole(ROLE_UE_LINKS);
        this.uniqueElementLinks = list;
    }

    public void setNotes(EOList list) {
        assert (list != null);
        list.setRole(ROLE_ACTION_ITEM_REMARKS);
        this.notes = list;
    }

    public int getIssueCount() {
        return this.issues.size();
    }

    public int getNoteCount() {
        return this.notes.size();
    }

    public int getLocalElementLinkCount() {
        return this.localElementLinks.size();
    }

    public int getUniqueElementLinkCount() {
        return this.uniqueElementLinks.size();
    }

    public boolean isEmpty() {
        return this.issues.size() == 0 && this.localElementLinks.size() == 0 && this.uniqueElementLinks.size() == 0 && this.notes.size() == 0;
    }
}

