/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableTreeDataView
extends AbstractModuleSpecificationPart
implements View {
    private final String label;
    private final String icon;
    private final Map<String, ColumnProvider> columnProviderMap;
    private final List<ColumnProvider> columnProviderList;

    public TableTreeDataView(String label, String icon, List<ColumnProvider> columnProviderList) {
        this.label = label;
        this.icon = icon;
        this.columnProviderMap = new HashMap<String, ColumnProvider>();
        this.columnProviderList = new ArrayList<ColumnProvider>();
        int columnProviderListCounter = 1;
        for (ColumnProvider part : columnProviderList) {
            ((AbstractModuleSpecificationPart)((Object)part)).setIndex(columnProviderListCounter);
            String partID = part.getID();
            this.columnProviderMap.put(partID, part);
            this.columnProviderList.add(part);
            ++columnProviderListCounter;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<ColumnProvider> getColumnProviderList() {
        return this.columnProviderList;
    }

    public ColumnProvider getColumnProvider(String id) {
        return this.columnProviderMap.get(id);
    }

    public ColumnProvider getColumnProvider(int index) {
        return this.getColumnProviderList().get(index);
    }

    public <T extends ColumnProvider> List<T> getColumnProviderListOfType(Class<T> type) {
        ArrayList<ColumnProvider> list = new ArrayList<ColumnProvider>(this.columnProviderMap.size());
        for (ColumnProvider child : this.columnProviderMap.values()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            list.add((ColumnProvider)type.cast(child));
        }
        TableTreeDataView.sortSpecificationPartList(list);
        return list;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getColumnProviderList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "TableTreeDataView";
    }
}

