/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ExportedObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Exporter
extends AbstractModuleSpecificationPart {
    private final String idOfAdapter;
    private final String dataName;
    private final String dataIcon;
    private final Map<String, ExportedObjectType> exportedObjectTypeMap;
    private final List<ExportedObjectType> exportedObjectTypeList;

    public Exporter(String idOfAdapter, String dataName, String dataIcon, List<ExportedObjectType> exportedObjectTypeList) {
        this.idOfAdapter = idOfAdapter;
        this.dataName = dataName;
        this.dataIcon = dataIcon;
        this.exportedObjectTypeMap = new HashMap<String, ExportedObjectType>();
        this.exportedObjectTypeList = new ArrayList<ExportedObjectType>();
        int exportedObjectTypeListCounter = 1;
        for (ExportedObjectType part : exportedObjectTypeList) {
            part.setIndex(exportedObjectTypeListCounter);
            String partID = part.getID();
            this.exportedObjectTypeMap.put(partID, part);
            this.exportedObjectTypeList.add(part);
            ++exportedObjectTypeListCounter;
        }
    }

    public String getIdOfAdapter() {
        return this.idOfAdapter;
    }

    public String getDataName() {
        return this.dataName;
    }

    public String getDataIcon() {
        return this.dataIcon;
    }

    public List<ExportedObjectType> getExportedObjectTypeList() {
        return this.exportedObjectTypeList;
    }

    public ExportedObjectType getExportedObjectType(String id) {
        return this.exportedObjectTypeMap.get(id);
    }

    public ExportedObjectType getExportedObjectType(int index) {
        return this.getExportedObjectTypeList().get(index);
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getExportedObjectTypeList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "Exporter";
    }
}

