/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification;

import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.RootFactory;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLRootElementFactoryWO;
import com.arcway.lib.codec.xml.XMLCoDec;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SpecificationReader {
    private static final ILogger logger = Logger.getLogger(SpecificationReader.class);
    private static SpecificationReader singleton;

    private SpecificationReader() {
    }

    public static SpecificationReader getDefault() {
        if (singleton == null) {
            singleton = new SpecificationReader();
        }
        return singleton;
    }

    public Map<String, ModuleSpecification> readAllModuleSpecifications() {
        Map<String, ModuleSpecification> moduleSpecMap = this.readConcreteModuleExtensionPoint();
        return moduleSpecMap;
    }

    public static ModuleSpecification readModuleSpecification(File moduleSpecificationFile) {
        FileInputStream inp;
        RootFactory rootFactory = new RootFactory();
        try {
            inp = new FileInputStream(moduleSpecificationFile);
        }
        catch (FileNotFoundException fneE) {
            logger.error("Could not open input stream for module specification file.", (Throwable)fneE);
            return null;
        }
        try {
            XMLCoDec.decode((InputStream)inp, (IXMLRootElementFactoryWO)rootFactory, (boolean)false);
        }
        catch (EXXMLDecodingFailed xdfE) {
            logger.error("Error while parsing the module specification file.", (Throwable)xdfE);
            return null;
        }
        ModuleSpecification moduleSpecification = rootFactory.getDeserialisedModuleSpecification();
        return moduleSpecification;
    }

    private Map<String, ModuleSpecification> readConcreteModuleExtensionPoint() {
        IExtension[] extensions;
        HashMap<String, ModuleSpecification> specificationMap = new HashMap<String, ModuleSpecification>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.arcway.cockpit.genericmodule", "concretemodule");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement configElement = currentExtension.getConfigurationElements()[0];
            if ("ConcreteModule".equals(configElement.getName())) {
                try {
                    URL installationRoot = ResourceManager.getDefault().getResourceURLByPluginID(configElement.getContributor().getName(), "/");
                    URL dataSpec = new URL(installationRoot, "spec/ModuleSpec.xml");
                    URL dataSpecAsFileURL = FileLocator.toFileURL((URL)dataSpec);
                    File dataSpecFile = new File(dataSpecAsFileURL.getPath());
                    ModuleSpecification moduleSpecification = SpecificationReader.readModuleSpecification(dataSpecFile);
                    if (moduleSpecification != null) {
                        ResourceManager.getDefault().registerConcreteModule(moduleSpecification.getModuleID(), configElement.getContributor().getName());
                        specificationMap.put(moduleSpecification.getModuleID(), moduleSpecification);
                    } else {
                        logger.warn("Couldn't load generic module " + configElement.getContributor().getName() + ". Module spec could not be loaded (null).");
                    }
                }
                catch (IOException ioE) {
                    logger.warn("Couldn't load generic module " + configElement.getContributor().getName() + ". Module spec could not be loaded.", (Throwable)ioE);
                }
            }
            ++n2;
        }
        return specificationMap;
    }
}

