/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.relationgraph;

import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.lib.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class RelationGraphLayoutProvider
implements IRelationGraphProvider {
    private final String moduleID;

    public RelationGraphLayoutProvider(String moduleID) {
        this.moduleID = moduleID;
    }

    public Color getBackgroundColor(ICockpitProjectData data, int nodeType) {
        Color backgroundColor = Color.LIGHTGRAY;
        if (nodeType == 2) {
            backgroundColor = Color.LIGHTBLUE;
        }
        return backgroundColor;
    }

    public Color getForegroundColor(ICockpitProjectData data, int nodeType) {
        return Color.DARKBLUE;
    }

    public Color getLineColor() {
        return Color.BLACK;
    }

    public Color getToolTipColor() {
        return Color.TOOLTIPYELLOW;
    }

    public boolean hasIcon(ICockpitProjectData data, int nodeType) {
        return this.getIcon(data, nodeType) != null;
    }

    public Image getIcon(ICockpitProjectData data, int nodeType) {
        return ((GenericModuleData)data).getStatusDependentIcon().getImage();
    }

    public String getLabel(ICockpitProjectData data, int nodeType) {
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(data.getProjectUID());
        return ((GenericModuleData)data).getDisplayRepresentation(modelController.getProjectLanguage());
    }

    public boolean hasSourceArrow(int edgeType, boolean virtualSource) {
        return !virtualSource && (edgeType == 3 || edgeType == 1);
    }

    public boolean hasTargetArrow(int edgeType, boolean virtualTarget) {
        return !virtualTarget && (edgeType == 2 || edgeType == 1);
    }

    public boolean showEdge(int edgeType) {
        return true;
    }

    public void dispose() {
    }
}

