/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.menu.actions;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionDelete
extends Action {
    private final Shell activeShell;
    private final IModelController modelCtrl;
    private final ArrayList<IModuleData> toBeDeleted;
    private final Runnable delete = new Runnable(){

        @Override
        public void run() {
            ActionDelete.this.deleteItems(ActionDelete.this.toBeDeleted);
        }
    };

    public ActionDelete(Shell activeShell, String moduleID, ArrayList<IModuleData> toBeDeleted) {
        this.activeShell = activeShell;
        String projectUID = toBeDeleted.get(0).getProjectUID();
        this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(moduleID).getModelController(projectUID);
        this.toBeDeleted = toBeDeleted;
    }

    public void run() {
        assert (this.toBeDeleted != null);
        assert (this.modelCtrl != null) : "modelCtrl must not be null";
        this.modelCtrl.executeTransaction(this.delete);
    }

    public void deleteItems(List<IModuleData> items_) {
        assert (this.modelCtrl != null);
        HashSet<IModuleData> items = new HashSet<IModuleData>(items_);
        PermissionManager permissionMgr = (PermissionManager)this.modelCtrl.getPermissionMgr();
        boolean hasPermission = permissionMgr.mayDelete(items);
        if (!hasPermission) {
            permissionMgr.showNoPermissionMsg(this.activeShell);
            return;
        }
        ModuleLockManager lockMgr = (ModuleLockManager)this.modelCtrl.getLockMgr();
        ArrayList<LockAccess> aquiredLocks = new ArrayList<LockAccess>();
        for (IModuleData item : items) {
            LockAccess lock = lockMgr.acquireRemoveLock((ICockpitProjectData)item);
            if (!lock.hasLock()) {
                this.releaseLocks(aquiredLocks);
                return;
            }
            aquiredLocks.add(lock);
        }
        ArrayList subItemsToBeDeleted = new ArrayList();
        for (IModuleData toDelete : items) {
            subItemsToBeDeleted.addAll(this.modelCtrl.getAllDescendants(toDelete));
        }
        items.addAll(subItemsToBeDeleted);
        MessageDialog messageDialog = new MessageDialog(this.activeShell, Messages.getString("ActionDelegateDelete.Confirmation.Title"), null, Messages.getString("ActionDelegateDelete.Confirmation.Message"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        if (messageDialog.open() == 0) {
            this.modelCtrl.deleteItems(items);
        } else {
            this.releaseLocks(aquiredLocks);
        }
    }

    private void releaseLocks(Collection<LockAccess> aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }
}

