/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.genericmodule.client.gui.linkviewcontribution.GenericModuleLinkViewContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.StringCondenser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LinkLabelProvider
implements IModuleLinkLabelProvider {
    private static final int DISPLAY_LENGHT = 60;
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private final Collection<String> linkableObjectTypeCollection;

    public LinkLabelProvider(String moduleID, ModuleSpecification moduleSpecification) {
        this.moduleID = moduleID;
        this.moduleSpecification = moduleSpecification;
        List<ModelElementLinkType> modelElementLinkTypeList = moduleSpecification.getModuleDataSpecification().getRelationTypeListOfType(ModelElementLinkType.class);
        this.linkableObjectTypeCollection = new ArrayList<String>(modelElementLinkTypeList.size());
        for (ModelElementLinkType modelElementLinkType : modelElementLinkTypeList) {
            this.linkableObjectTypeCollection.add(modelElementLinkType.getLinkedObjectTypeID());
        }
    }

    public Image getImage(Object element) {
        GenericModuleLinkViewContent linkViewContent;
        if (element instanceof GenericModuleData) {
            GenericModuleData item = (GenericModuleData)((Object)element);
            if (item.getGenericModuleID().equals(this.moduleID)) {
                return item.getStatusDependentIcon().getImage();
            }
        } else if (element instanceof GenericModuleLinkViewContent && this.linkableObjectTypeCollection.contains((linkViewContent = (GenericModuleLinkViewContent)element).getObjectTypeID())) {
            ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(linkViewContent.getObjectTypeID());
            if (objectType.getObjectTypeIcon() != null && objectType.getObjectTypeIcon().length() > 0) {
                return ResourceManager.getDefault().getImage(this.moduleID, objectType.getObjectTypeIcon());
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        return this.getText(element, false);
    }

    public String getText(Object element, boolean limited) {
        GenericModuleLinkViewContent linkViewContent;
        String text = null;
        if (element instanceof GenericModuleData) {
            GenericModuleData item = (GenericModuleData)((Object)element);
            if (item.getGenericModuleID().equals(this.moduleID)) {
                text = item.getDisplayRepresentation();
                text = StringUtil.removeNewlinesAndTrim((String)text);
                if (limited) {
                    text = StringCondenser.cutOffEnd((String)text, (int)60);
                }
            }
        } else if (element instanceof GenericModuleLinkViewContent && this.linkableObjectTypeCollection.contains((linkViewContent = (GenericModuleLinkViewContent)element).getObjectTypeID())) {
            ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(linkViewContent.getObjectTypeID());
            text = new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault());
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ILabelProviderListener listener) {
        throw new UnsupportedOperationException();
    }

    public boolean isLabelProperty(Object element, String property) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
    }
}

