/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dnd;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ModuleDataInternalTransfer;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RelationDragNDropSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider {
    private static final String TRANSFER_TYPE_PREFIX = "GenericModule_RelationDnD-" + UUIDGenerator.getUniqueID() + "-";
    private final String moduleID;
    private final SetMap<String, String> map_moduleDataCockpitType_linkableObjectCockpitType;
    private final Map<String, String> map_mdTypePlusLoType_linkTypeID;
    private final Map<String, String> map_mdTypePlusLoType_mdCardinality;
    private final Map<String, String> map_mdTypePlusLoType_loCardinality;
    private final Map<String, ModuleDataRelationType> map_RelationLinkTypeID_ModuleDataRelationType;
    private final Transfer transfer;
    protected IModelController modelController;
    private static GenericModuleRelationDnDTransferContent transferData = null;
    private static final int MESSAGE_LINES = 8;

    public RelationDragNDropSupport(String moduleID, ModuleDataSpecification moduleDataSpecification, IModelController modelController) {
        this.moduleID = moduleID;
        this.modelController = modelController;
        this.transfer = new ModuleDataInternalTransfer(String.valueOf(TRANSFER_TYPE_PREFIX) + moduleID);
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        this.map_moduleDataCockpitType_linkableObjectCockpitType = new SetMap();
        this.map_mdTypePlusLoType_linkTypeID = new HashMap<String, String>();
        this.map_mdTypePlusLoType_mdCardinality = new HashMap<String, String>();
        this.map_mdTypePlusLoType_loCardinality = new HashMap<String, String>();
        this.map_RelationLinkTypeID_ModuleDataRelationType = new HashMap<String, ModuleDataRelationType>();
        for (ModuleDataRelationType relationType : moduleDataSpecification.getRelationTypeListOfType(ModuleDataRelationType.class)) {
            MDRelationParticipant moduleDataParticipant = relationType.getMDRelationParticipant(0);
            MDRelationParticipant linkableObjectParticipant = relationType.getMDRelationParticipant(1);
            String mdCockpitType = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, moduleDataParticipant.getObjectTypeIDOfParticipant());
            String loCockpitType = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, linkableObjectParticipant.getObjectTypeIDOfParticipant());
            String linkTypeID = linkTypeHelper.getRelationLinkTypeID(relationType.getRelationTypeID());
            this.map_moduleDataCockpitType_linkableObjectCockpitType.add((Object)mdCockpitType, (Object)loCockpitType);
            this.map_mdTypePlusLoType_linkTypeID.put(String.valueOf(mdCockpitType) + "\n" + loCockpitType, linkTypeID);
            this.map_mdTypePlusLoType_mdCardinality.put(String.valueOf(mdCockpitType) + "\n" + loCockpitType, moduleDataParticipant.getCardinality());
            this.map_mdTypePlusLoType_loCardinality.put(String.valueOf(mdCockpitType) + "\n" + loCockpitType, linkableObjectParticipant.getCardinality());
            this.map_RelationLinkTypeID_ModuleDataRelationType.put(linkTypeID, relationType);
        }
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), (IClientFunctionLicenseType2)ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID), (IProjectAgentProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), (IActiveProjectProvider)this);
    }

    public DropTarget getDropTarget() {
        return new DropTarget(this.getDropOperations(), this.getTransfers(), this.getDropHandler(), (IClientFunctionLicenseType2)ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID), (IProjectAgentProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 20;
    }

    private int getDropOperations() {
        return 20;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                if (selectedItems.isEmpty()) {
                    return false;
                }
                String dataType = null;
                ArrayList<GenericModuleData> validSelectedItems = new ArrayList<GenericModuleData>(selectedItems.size());
                for (Object selectedItem : selectedItems) {
                    if (selectedItem instanceof GenericModuleData) {
                        GenericModuleData moduleData = (GenericModuleData)((Object)selectedItem);
                        if (dataType == null) {
                            dataType = moduleData.getTypeID();
                            if (!RelationDragNDropSupport.this.map_moduleDataCockpitType_linkableObjectCockpitType.containsKey((Object)dataType)) {
                                return false;
                            }
                        } else if (!moduleData.getTypeID().equals(dataType)) {
                            return false;
                        }
                        validSelectedItems.add(moduleData);
                        continue;
                    }
                    return false;
                }
                transferData = new GenericModuleRelationDnDTransferContent(validSelectedItems, dataType, RelationDragNDropSupport.this.modelController.getProjectUID());
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                return transferData.uid;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    private IDropHandler getDropHandler() {
        IDropHandler dropHandler = new IDropHandler(){

            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (transferData == null) {
                    return false;
                }
                if (event.item != null && event.item.getData() != null && event.item.getData() instanceof GenericModuleData) {
                    Set existingLinks;
                    String loCardinality;
                    TransferData dataType = RelationDragNDropSupport.this.extractRequiredDatatype(event.dataTypes);
                    if (dataType == null) {
                        return false;
                    }
                    parametersToChoose.requestedTransferType = dataType;
                    int operation = RelationDragNDropSupport.this.extractRequiredOperation(event.operations, event.detail);
                    if (operation == 0) {
                        return false;
                    }
                    parametersToChoose.requestedOperation = operation;
                    if (location != 3) {
                        return false;
                    }
                    if (!transferData.projectUID.equals(RelationDragNDropSupport.this.modelController.getProjectUID())) {
                        return false;
                    }
                    GenericModuleData targetItem = (GenericModuleData)((Object)event.item.getData());
                    if (!RelationDragNDropSupport.this.map_moduleDataCockpitType_linkableObjectCockpitType.get((Object)transferData.sourceCockpitType).contains(targetItem.getTypeID())) {
                        return false;
                    }
                    if (transferData.relationSources.contains((Object)targetItem)) {
                        return false;
                    }
                    String mdTypePlusLOType = String.valueOf(transferData.sourceCockpitType) + "\n" + targetItem.getTypeID();
                    String linkTypeID = (String)RelationDragNDropSupport.this.map_mdTypePlusLoType_linkTypeID.get(mdTypePlusLOType);
                    String mdCardinality = (String)RelationDragNDropSupport.this.map_mdTypePlusLoType_mdCardinality.get(mdTypePlusLOType);
                    if (mdCardinality.equals("none-or-one")) {
                        for (GenericModuleData sourceItem : transferData.relationSources) {
                            Set existingLinks2 = RelationDragNDropSupport.this.modelController.getLinksForModuleDataItem((IModuleData)sourceItem, linkTypeID);
                            if (existingLinks2.size() != 1) continue;
                            return false;
                        }
                    }
                    if ((loCardinality = (String)RelationDragNDropSupport.this.map_mdTypePlusLoType_loCardinality.get(mdTypePlusLOType)).equals("none-or-one") && (existingLinks = RelationDragNDropSupport.this.modelController.getLinksForLinkableObject(targetItem.getUID(), linkTypeID)).size() == 1) {
                        return false;
                    }
                    parametersToChoose.requestedFeedbackTypes = 25;
                    return true;
                }
                return false;
            }

            public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
                GenericModuleData targetItem = (GenericModuleData)((Object)event.item.getData());
                ArrayList<GenericModuleData> sourceData = new ArrayList<GenericModuleData>(transferData.relationSources);
                RelationDragNDropSupport.this.doLink(sourceData, targetItem, targetControl.getShell());
                return true;
            }
        };
        return dropHandler;
    }

    private int extractRequiredOperation(int operations, int requestedOperation) {
        if (requestedOperation == 16) {
            if ((operations & 0x10) != 0 || (operations & 4) != 0) {
                return 4;
            }
            return 0;
        }
        if ((requestedOperation & 4) != 0) {
            return 4;
        }
        return 0;
    }

    private TransferData extractRequiredDatatype(TransferData[] dataTypes) {
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.transfer.isSupportedType(dataType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    private void doLink(final Collection<GenericModuleData> droppedItems, final GenericModuleData targetItem, Shell shell) {
        if (ModuleLib2Plugin.getDefault().getPreferenceStore().getString("PromptWhenLinking").equals("prompt") && MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)Messages.getString("RelationDragNDropSupport.ConfirmDlgTitle"), (String)this.createLinkMessage(droppedItems, targetItem), (String)Messages.getString("RelationDragNDropSupport.DontAskToggleText"), (boolean)false, (IPreferenceStore)ModuleLib2Plugin.getDefault().getPreferenceStore(), (String)"PromptWhenLinking").getReturnCode() != 0) {
            return;
        }
        GenericModuleData droppedItem = droppedItems.iterator().next();
        String linkTypeID = this.map_mdTypePlusLoType_linkTypeID.get(String.valueOf(droppedItem.getTypeID()) + "\n" + targetItem.getTypeID());
        if (!((PermissionManager)this.modelController.getPermissionMgr()).mayLinkItems(droppedItems, targetItem, linkTypeID)) {
            MessageDialog.openError((Shell)shell, (String)Messages.getString("RelationDragNDropSupport.NoLinkTitle"), (String)Messages.getString("RelationDragNDropSupport.NoPermissionTxt"));
            return;
        }
        HashSet<GenericModuleData> allItems = new HashSet<GenericModuleData>(droppedItems);
        allItems.add(targetItem);
        HashSet<LockAccess> locks = new HashSet<LockAccess>();
        for (GenericModuleData item : allItems) {
            LockAccess lock = this.modelController.getLockMgr().acquireEditLock((ICockpitProjectData)item, false);
            locks.add(lock);
            if (lock.hasLock()) continue;
            MessageDialog.openError((Shell)shell, (String)Messages.getString("RelationDragNDropSupport.NoLinkTitle"), (String)Messages.getString("RelationDragNDropSupport.NoLockTxt"));
            for (LockAccess _lock : locks) {
                _lock.releaseLocks();
            }
            return;
        }
        this.modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                for (GenericModuleData sourceItem : droppedItems) {
                    RelationDragNDropSupport.this.modelController.createLink(targetItem.getUID(), (IModuleData)sourceItem, (String)RelationDragNDropSupport.this.map_mdTypePlusLoType_linkTypeID.get(String.valueOf(sourceItem.getTypeID()) + "\n" + targetItem.getTypeID()));
                }
            }
        });
        this.modelController.getPropertyChangesManager().signalPropertyChanges(null, droppedItems, null, GenericModuleData.class);
        this.modelController.getPropertyChangesManager().signalPropertyChanges(null, Collections.singleton(targetItem), null, GenericModuleData.class);
    }

    private String createLinkMessage(Collection<GenericModuleData> droppedItems, GenericModuleData targetItem) {
        boolean paneTooSmall;
        int messageLines = 8;
        messageLines -= 2;
        String message = String.valueOf(Messages.getString("RelationDragNDropSupport.LinkInformationMessage")) + "\n";
        boolean bl = paneTooSmall = --messageLines - droppedItems.size() < 0;
        if (paneTooSmall) {
            --messageLines;
        }
        for (GenericModuleData droppedItem : droppedItems) {
            if (messageLines <= 0) break;
            message = String.valueOf(message) + "\n" + droppedItem.getDisplayRepresentation() + " ==> " + targetItem.getDisplayRepresentation();
            --messageLines;
        }
        if (paneTooSmall) {
            message = String.valueOf(message) + "\n...";
        }
        message = String.valueOf(message) + "\n\n" + Messages.getString("RelationDragNDropSupport.NoUndo");
        return message;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
    }

    public String getActiveProject() {
        return this.modelController != null ? this.modelController.getProjectUID() : null;
    }

    private static class GenericModuleRelationDnDTransferContent {
        public String uid;
        public String projectUID;
        public Collection<GenericModuleData> relationSources;
        public String sourceCockpitType;

        public GenericModuleRelationDnDTransferContent(Collection<GenericModuleData> relationSources, String sourceCockpitType, String projectUID) {
            this.relationSources = relationSources;
            this.sourceCockpitType = sourceCockpitType;
            this.projectUID = projectUID;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

