/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui;

import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CopyManager
extends AbstractCopyManager {
    private final IDataTypesHelper dataTypesHelper;
    private final SetMap<String, String> map_cockpitTypeID_optionalMDContextLinkTypeIDs;
    private final SetMap<String, String> map_cockpitTypeID_optionalLOContextLinkTypeIDs;
    private final SetMap<String, String> map_cockpitTypeID_optionalMDFrameContextLinkTypeIDs;
    private final SetMap<String, String> map_cockpitTypeID_requiredContextLinkTypeIDs;

    public CopyManager(String moduleID, ModuleDataSpecification moduleDataSpecification) {
        super(ModuleIdentification.getFullModuleID(moduleID), (IClientDataFactory)new ClientDataFactory(moduleID, moduleDataSpecification), (ILinkTypeHelper_Shared)GMLinkTypeHelper_Shared.getDefault(moduleID));
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        this.dataTypesHelper = GMDataTypesHelper.getDefault(moduleID);
        this.map_cockpitTypeID_optionalMDContextLinkTypeIDs = new SetMap();
        this.map_cockpitTypeID_optionalLOContextLinkTypeIDs = new SetMap();
        this.map_cockpitTypeID_optionalMDFrameContextLinkTypeIDs = new SetMap();
        this.map_cockpitTypeID_requiredContextLinkTypeIDs = new SetMap();
        for (ObjectType objectType : moduleDataSpecification.getObjectTypeList()) {
            for (LinkedModuleDataAttribute linkedModuleDataAttribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                this.map_cockpitTypeID_requiredContextLinkTypeIDs.add((Object)ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID()), (Object)linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), linkedModuleDataAttribute.getAttributeID()));
            }
            for (LinkedFrameDataAttribute linkedFrameDataAttribute : objectType.getAttributeListOfType(LinkedFrameDataAttribute.class)) {
                this.map_cockpitTypeID_optionalMDFrameContextLinkTypeIDs.add((Object)ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID()), (Object)linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), linkedFrameDataAttribute.getAttributeID()));
            }
        }
        for (ModuleDataRelationType relationType : moduleDataSpecification.getRelationTypeListOfType(ModuleDataRelationType.class)) {
            MDRelationParticipant mDRelationParticipant = relationType.getMDRelationParticipant(0);
            MDRelationParticipant linkableObjectParticipant = relationType.getMDRelationParticipant(1);
            this.map_cockpitTypeID_optionalMDContextLinkTypeIDs.add((Object)ClientDataFactory_TypesHelper.getDataTypeID(moduleID, mDRelationParticipant.getObjectTypeIDOfParticipant()), (Object)linkTypeHelper.getRelationLinkTypeID(relationType.getRelationTypeID()));
            this.map_cockpitTypeID_optionalLOContextLinkTypeIDs.add((Object)ClientDataFactory_TypesHelper.getDataTypeID(moduleID, linkableObjectParticipant.getObjectTypeIDOfParticipant()), (Object)linkTypeHelper.getRelationLinkTypeID(relationType.getRelationTypeID()));
        }
        super.construct();
    }

    protected void customCopyOperations(IModuleData item, IModuleData parent, List<IModuleData> rootItems, List<IModuleData> items, Set<EOLink> links, Set<EOLink> mdLinksToContext, Set<EOLink> loLinksToContext, Set<EOLink> mdLinksToFrameContext, Set<IModuleData> contextItems, Set<EOLink> linksToCopiedContext, IModelController modelController) {
    }

    protected void customPasteOperations(IModuleData target, List<IModuleData> rootItems, List<IModuleData> items, List<EOLink> links, List<EOLink> mdLinksToContext, List<EOLink> loLinksToContext, List<IModuleData> contextItems, List<EOLink> linksToCopiedContext, Map<String, String> uidMap, IModelController modelController) {
        if (target == null) {
            for (IModuleData rootItem : rootItems) {
                GenericModuleData rootItemInModel = (GenericModuleData)modelController.getItem(rootItem.getTypeID(), uidMap.get(rootItem.getUID()));
                for (String attributeID : rootItemInModel.getTypeDescription().getAttributeIDs()) {
                    ModuleDataAttributeBoolean overrideParentSettingsAttribute;
                    if (!attributeID.endsWith("-overrideparentsettings") || (overrideParentSettingsAttribute = (ModuleDataAttributeBoolean)rootItemInModel.getAttribute(attributeID)).getValue()) continue;
                    overrideParentSettingsAttribute.setValue(true);
                    String coreAttributeID = attributeID.substring(0, attributeID.lastIndexOf("-overrideparentsettings"));
                    String useDefaultPrefixAttributeID = String.valueOf(coreAttributeID) + "-usedefaultprefix";
                    ((ModuleDataAttributeBoolean)rootItemInModel.getAttribute(useDefaultPrefixAttributeID)).setValue(true);
                }
            }
        }
    }

    protected Collection<String> getOptionalMDContextLinkTypes(String moduleDataCockpitTypeID) {
        return this.map_cockpitTypeID_optionalMDContextLinkTypeIDs.get((Object)moduleDataCockpitTypeID);
    }

    protected Collection<String> getOptionalLOContextLinkTypes(String moduleDataCockpitTypeID) {
        return this.map_cockpitTypeID_optionalLOContextLinkTypeIDs.get((Object)moduleDataCockpitTypeID);
    }

    protected Collection<String> getOptionalMDFrameContextLinkTypes(String moduleDataCockpitTypeID) {
        return this.map_cockpitTypeID_optionalMDFrameContextLinkTypeIDs.get((Object)moduleDataCockpitTypeID);
    }

    protected Collection<String> getRequiredContextLinkTypes(String moduleDataCockpitTypeID) {
        return this.map_cockpitTypeID_requiredContextLinkTypeIDs.get((Object)moduleDataCockpitTypeID);
    }

    protected Collection<String> getPossibleParentDataTypes(String typeID) {
        return this.dataTypesHelper.getParentTypeIDs(typeID);
    }

    protected Collection<String> getAllCopyableDataTypes() {
        return this.dataTypesHelper.getDocumentationDataTypes();
    }
}

