/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.licensetypes;

import com.arcway.cockpit.frame.client.global.license.HierarchicalClientFunctionLicenseTypeBoolean;
import com.arcway.cockpit.frame.client.global.license.IClientModuleLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public abstract class AbstractClientFunctionLicenseTypeGM
extends HierarchicalClientFunctionLicenseTypeBoolean
implements IExecutableExtension {
    private static final ILogger LOGGER = Logger.getLogger(AbstractClientFunctionLicenseTypeGM.class);
    private static final String KEY_PREFIX = "modules.genericmodule";
    private static final Collection<String> problemModules = new HashSet<String>();
    private String moduleID;

    public AbstractClientFunctionLicenseTypeGM(String moduleID) {
        this.moduleID = moduleID;
    }

    public AbstractClientFunctionLicenseTypeGM() {
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        ModuleSpecification spec = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        Collection<String> licenseOptions = Collections.emptySet();
        if (spec.getLicenseOptions() != null && spec.getLicenseOptions().getLicenseOptions() != null && spec.getLicenseOptions().getLicenseOptions().trim().length() > 0) {
            if (SpecificationProvider.getDefault().verifySpecificationSignature(this.moduleID)) {
                licenseOptions = Arrays.asList(spec.getLicenseOptions().getLicenseOptions().split(","));
            } else if (!problemModules.contains(this.moduleID)) {
                problemModules.add(this.moduleID);
                LOGGER.warn("The specification of module " + this.moduleID + " does not have a valid signature. License mode will be set to default.");
            }
        }
        for (Map.Entry<IClientProductLicenseType, Object> entry : this.getProductLicenseSettings(licenseOptions).entrySet()) {
            AbstractClientFunctionLicenseTypeGM.setLicense((IClientProductLicenseType)entry.getKey(), (String)this.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<IClientProductLicenseType, Object> entry : this.getModuleLicenseSettings(licenseOptions).entrySet()) {
            AbstractClientFunctionLicenseTypeGM.setLicense((IClientModuleLicenseType)((IClientModuleLicenseType)entry.getKey()), (String)this.getKey(), (Object)entry.getValue());
        }
    }

    public final String getKey() {
        String suffix = this.getKeySuffix();
        return "modules.genericmodule." + this.moduleID + (suffix.length() > 0 ? "." + suffix : "");
    }

    protected final String getModuleID() {
        return this.moduleID;
    }

    protected abstract String getKeySuffix();

    protected abstract Map<IClientProductLicenseType, Object> getProductLicenseSettings(Collection<String> var1);

    protected abstract Map<IClientModuleLicenseType, Object> getModuleLicenseSettings(Collection<String> var1);
}

