/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.dataexchange.ExValue;
import com.arcway.cockpit.modulelib2.client.dataexchange.ImValue;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ImExGenericModuleData
extends AbstractImExModuleData {
    protected String moduleID;
    protected String objectTypeID;
    protected String internalIdentifier;
    private String displayName;
    private String typeName;
    private Map<String, ImValue> map_attributeID_value_forImport;
    private Map<String, ExValue> map_attributeID_value_forExport;

    public ImExGenericModuleData(String moduleID, String objectTypeID) {
        this.moduleID = moduleID;
        this.objectTypeID = objectTypeID;
        this.map_attributeID_value_forImport = new HashMap<String, ImValue>();
    }

    public ImExGenericModuleData(GenericModuleData item, IModelController modelController, String displayName, String typeName, Locale locale) {
        super((AbstractModuleData)item, modelController, locale);
        this.moduleID = item.getGenericModuleID();
        this.objectTypeID = ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID());
        this.displayName = displayName;
        this.typeName = typeName;
        this.map_attributeID_value_forExport = new HashMap<String, ExValue>();
    }

    public void addAttributeValue(String attributeID, ImValue value) {
        this.map_attributeID_value_forImport.put(attributeID, value);
    }

    void addAttributeValue(String attributeID, ExValue value) {
        this.map_attributeID_value_forExport.put(attributeID, value);
    }

    public String getUniqueIdentifier() {
        return this.internalIdentifier;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public String getObjectTypeID() {
        return this.objectTypeID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Long getAttributeValueAsInteger(String attributeID) {
        return this.map_attributeID_value_forExport.get(attributeID).getValueAsInteger();
    }

    public String getAttributeValueAsString(String attributeID) {
        return this.map_attributeID_value_forExport.get(attributeID).getValueAsString();
    }

    public String getChildrenIDPrefix(String childObjectTypeID) {
        return this.map_attributeID_value_forExport.get("childrenIDPrefix-" + childObjectTypeID).getValueAsString();
    }

    public int getAttributeFormat(String attributeID) {
        return this.map_attributeID_value_forExport.get(attributeID).getFormat();
    }

    public String getImportedAttributeValue(String attributeID) {
        ImValue imValue = this.map_attributeID_value_forImport.get(attributeID);
        if (imValue != null) {
            return imValue.getValueAsString();
        }
        return null;
    }

    public Map<String, ImValue> getImportedFixAttributeValues() {
        return this.map_attributeID_value_forImport;
    }

    @Deprecated
    public AbstractModuleData getModuleDataItem() {
        return this.getModuleData();
    }

    public boolean equals(Object object) {
        if (object instanceof ImExGenericModuleData) {
            return this.getUniqueIdentifier().equals(((ImExGenericModuleData)((Object)object)).getUniqueIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.getUniqueIdentifier().hashCode();
    }
}

