/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.framestandaloneserverproxywithcommit;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.Messages;
import de.plans.psc.client.communication.ServerConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;

public class ProjectNameValidator
implements IInputValidator {
    private final Collection existingNames = new ArrayList();

    public ProjectNameValidator(ServerConnection server) {
        try {
            Collection allProjects = ProjectMgr.getProjectMgr().getEOProjectsOnServer(server.getServerID());
            for (EOProject p : allProjects) {
                this.existingNames.add(Project.getProjectName((EOProject)p));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ProjectNameValidator(IProjectAgent projectAgent) {
        try {
            Collection allProjects = ProjectMgr.getProjectMgr().getEOProjectsOnServer(projectAgent.getServerID());
            for (EOProject p : allProjects) {
                if (p.getProjectUID().equals(projectAgent.getUID())) continue;
                this.existingNames.add(Project.getProjectName((EOProject)p));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String isValid(String newText) {
        if (newText == null || newText.trim().equals("")) {
            return Messages.getString("RenameProjectValidator.The_project_name_mustn__t_be_empty._4");
        }
        if (newText.length() > 255) {
            return String.valueOf(Messages.getString("RenameProjectValidator.0")) + 255 + Messages.getString("RenameProjectValidator.1");
        }
        for (String n : this.existingNames) {
            if (!n.equalsIgnoreCase(newText.trim())) continue;
            return String.valueOf(Messages.getString("ProjectNameValidator.project_exists1")) + newText + Messages.getString("ProjectNameValidator.project_exists2");
        }
        return null;
    }
}

