/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.framestandaloneserverproxywithcommit;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.WorkspaceInitializer;
import com.arcway.cockpit.frame.client.global.gui.validators.ChangeUserNameValidator;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectView;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IGeneralServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.DummyServerConnection;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.LocalClientProductLicenseManager;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.Messages;
import com.arcway.lib.network.UserNameRetriever;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.IExecUIOperations;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServer;
import de.plans.psc.shared.message.EOServerInfo;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import de.plans.psc.shared.serverexceptions.EXServerException;
import de.plans.psc.shared.serverexceptions.PSCAbstractExceptionDecoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class GeneralServerProxy
implements IGeneralServerProxy {
    public static final String StandaloneServerID = "standalone";
    private final ServerConnection dummyServerConnection;
    private final List<IServerStatusChangedListener> serverStatusChangedListeners = new ArrayList<IServerStatusChangedListener>();

    public GeneralServerProxy() {
        this.dummyServerConnection = new DummyServerConnection(new DummyServer(), new DummyRequestForwarder());
    }

    public Collection<ServerConnection> getServerConnections() {
        return Collections.singletonList(this.dummyServerConnection);
    }

    public ServerConnection getServerConnection(String serverID) {
        if (this.dummyServerConnection.getServerID().equals(serverID)) {
            return this.dummyServerConnection;
        }
        return null;
    }

    public void disconnect(String serverID) {
        for (IServerStatusChangedListener listener : this.serverStatusChangedListeners) {
            listener.logoff(this.dummyServerConnection);
        }
    }

    public void addServerStatusChangedListener(IServerStatusChangedListener listener) {
        this.serverStatusChangedListeners.add(listener);
    }

    public void removeServerStatusChangedListener(IServerStatusChangedListener listener) {
        this.serverStatusChangedListeners.remove(listener);
    }

    public boolean mayAdministrateServers() {
        return false;
    }

    public boolean deleteServer(EOServer server) {
        return true;
    }

    public boolean arePermissionsNeeded() {
        return false;
    }

    public boolean isOldWorkspaceMigratable(File oldWorkspaceFolder) {
        ServerConnection serverConnection = this.dummyServerConnection;
        boolean isMigratable = false;
        try {
            File serverFolder = WorkspaceInitializer.calculateServerFolder((File)oldWorkspaceFolder, (String)serverConnection.getServerID());
            isMigratable = serverFolder.exists() && serverFolder.isDirectory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isMigratable;
    }

    public void setupWorkspace(IWorkbenchPage initalWorkbenchPage, File oldWorkspaceFolder) {
        block3: {
            Shell shell = initalWorkbenchPage.getWorkbenchWindow().getShell();
            ServerConnection serverConnection = this.dummyServerConnection;
            IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
            if (serverProxy != null) {
                try {
                    String userName = UserNameRetriever.getUsername();
                    serverProxy.setUserName(userName);
                    ProjectView.refresh1();
                }
                catch (UserNameRetriever.UnableToRetrieveUsernameException e) {
                    if (!serverProxy.mayChangeUserName()) break block3;
                    String title = Messages.getString("ChangeUserName.1");
                    String msg = Messages.getString("ChangeUserName.2");
                    String oldName = serverConnection.getUserName();
                    InputDialog dialog = new InputDialog(shell, title, msg, oldName, (IInputValidator)new ChangeUserNameValidator());
                    dialog.setBlockOnOpen(true);
                    int answer = dialog.open();
                    if (answer != 0) break block3;
                    serverProxy.setUserName(dialog.getValue());
                    ProjectView.refresh1();
                }
            }
        }
    }

    public boolean canServerProvideLicenses() {
        return false;
    }

    public IClientProductLicenseManager getProductLicenseManager() {
        return LocalClientProductLicenseManager.getDefault();
    }

    private static class DummyRequestForwarder
    extends RequestForwarder {
        private DummyRequestForwarder() {
        }

        public void addServerConnection(EOServer server) {
        }

        public void addServerStatusChangedListener(IServerStatusChangedListener listener) {
        }

        public void construct(PSCAbstractMessageDataFactory messageFactory, PSCAbstractExceptionDecoder exceptionDecoder, IExecUIOperations threadRunner, PSCApplicationIdentifier applicationIdentifier) {
        }

        public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) {
            return null;
        }

        public void disconnect(String clusterID) {
        }

        public void disconnectAll() {
        }

        public void downloadFiles(String serverID, List<String> transferIDs, List<File> files) throws UnknownServerException, ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException {
        }

        public List<ServerConnection> getOpenServerConnections() {
            return Collections.emptyList();
        }

        public ServerConnection getServerConnection(String serverID) {
            return null;
        }

        public List<ServerConnection> getServerConnections() {
            return Collections.emptyList();
        }

        public EOServerInfo getServerInfo(String clusterID) {
            return null;
        }

        public String getServerName(String serverID) {
            return Messages.getString("GeneralServerProxy.standalone");
        }

        public EOUserAndGroupAndPermissions getUserData(String clusterID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
            return null;
        }

        public EOUserAndGroupAndPermissions getUserData(String clusterID) {
            return null;
        }

        public void modifyServerConnection(EOServer server) {
        }

        public void parametersChanged() {
        }

        public void registerParameterSets(XMLConfigParameterMgr parameterMgr) {
        }

        public void removeServerStatusChangedListener(IServerStatusChangedListener listener) {
        }

        public synchronized EOServerResponse sendRequest(String serverID, EOClientRequest request) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
            return null;
        }

        public void uploadFiles(String serverID, List<String> transferIDs, List<File> files) throws UnknownServerException, ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException {
        }
    }

    private static class DummyServer
    extends EOServer {
        private DummyServer() {
        }

        protected boolean addChildFromXML(EncodableObjectBase newChild) {
            return false;
        }

        public String getDefaultPwd() {
            return "";
        }

        public String getDefaultUser() {
            return "";
        }

        public String getServerID() {
            return GeneralServerProxy.StandaloneServerID;
        }

        public String getServerName() {
            return Messages.getString("GeneralServerProxy.standalone");
        }

        public String getServerURL() {
            return "Standalone";
        }

        public int getTimerInterval() {
            return -1;
        }

        protected boolean hasChildren() {
            return false;
        }

        public boolean isLocal() {
            return true;
        }

        public void reset() {
        }

        protected boolean setAttributeFromXML(String name, String value) {
            return false;
        }

        public void setDefaultPwd(String defaultPwd) {
        }

        public void setIsLocal(boolean isLocal) {
        }

        public void setServerID(String serverID) {
        }

        public void setServerName(String serverName) {
        }

        public void setServerURL(String serverURL) {
        }

        public void setTimerInterval(int interval) {
        }
    }
}

