/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.cockpitadapter.locks;

import com.arcway.lib.java.Assert;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.List;
import java.util.Map;

public abstract class EODataLock
extends EOPlatformLock {
    public static final String XML_TAG_DATALOCK = "lock.data";
    private static final String XML_ATTRIBUTE_REPOSITORYOBJECTTYPEID = "repositoryobjecttypeid";
    private static final String XML_ATTRIBUTE_COCKPITDATAUID = "cockpitdatauid";
    private IRepositoryObjectTypeID repositoryObjectTypeID;
    private String cockpitDataUID;

    public EODataLock(String xmlName, String commitUID, IRepositoryObjectTypeID repositoryObjectTypeID, String cockpitDataUID) {
        super(xmlName, commitUID);
        Assert.checkArgumentBeeingNotNull((Object)repositoryObjectTypeID);
        Assert.checkArgumentBeeingNotNull((Object)cockpitDataUID);
        this.repositoryObjectTypeID = repositoryObjectTypeID;
        this.cockpitDataUID = cockpitDataUID;
    }

    EODataLock(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    EODataLock(String xmlName, String commitUID, Map attributes) {
        super(xmlName, commitUID, attributes);
    }

    public IRepositoryObjectTypeID getObjectTypeID() {
        return this.repositoryObjectTypeID;
    }

    public String getCockpitDataUID() {
        return this.cockpitDataUID;
    }

    @Override
    protected boolean setAttributeFromXML(String name, final String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_REPOSITORYOBJECTTYPEID)) {
            this.repositoryObjectTypeID = new IRepositoryObjectTypeID(){

                public String toCanonicalString() {
                    return value;
                }
            };
            success = true;
        } else if (name.equals(XML_ATTRIBUTE_COCKPITDATAUID)) {
            this.cockpitDataUID = value;
            success = true;
        } else {
            success = super.setAttributeFromXML(name, value);
        }
        return success;
    }

    @Override
    protected void appendAttributesToList(List attributes) {
        super.appendAttributesToList(attributes);
        attributes.add(new EOPlatformLock.KeyValue(XML_ATTRIBUTE_REPOSITORYOBJECTTYPEID, this.repositoryObjectTypeID.toCanonicalString()));
        attributes.add(new EOPlatformLock.KeyValue(XML_ATTRIBUTE_COCKPITDATAUID, this.cockpitDataUID));
    }
}

