/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public final class EOPlanTransferRequest
extends EOEncodableObject {
    public static String XML_NAME = "frame.plantransfer";
    private static final String ATTR_TAG_PROJECT_UID = "projectuid";
    private static final String ATTR_TAG_TRANSFERTYPE = "transfertype";
    private List planUIDs = new ArrayList();
    private String projectUID;
    private int transfertype;
    public static final int TRANSFER_TYPE_DOWNLOAD = 1;
    public static final int TRANSFER_TYPE_UPLOAD = 2;

    public EOPlanTransferRequest() {
        super(XML_NAME);
    }

    public EOPlanTransferRequest(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOPlanTransferRequest(String projectUID, int transferType, List planUIDs) {
        super(XML_NAME);
        this.projectUID = projectUID;
        if (transferType == 1 || transferType == 2) {
            this.transfertype = transferType;
        }
        this.planUIDs = planUIDs;
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild.getTag().equals("Value")) {
            this.planUIDs.add(newChild);
            return true;
        }
        return false;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_TRANSFERTYPE, this.transfertype);
    }

    protected boolean hasChildren() {
        return this.planUIDs.size() > 0;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(ATTR_TAG_TRANSFERTYPE)) {
            this.transfertype = this.toInt(value);
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        int i = 0;
        while (i < this.planUIDs.size()) {
            ((EOValue)this.planUIDs.get(i)).writeXMLBody(writeContext, depth);
            ++i;
        }
    }

    public String getProjectUid() {
        assert (this.projectUID != null) : "projectUID is null";
        assert (!this.projectUID.equals("")) : "projectUID is invalid";
        return this.projectUID;
    }

    public int getPlanUIDCount() {
        assert (this.planUIDs != null) : "planUIDs is null";
        return this.planUIDs.size();
    }

    public String getPlanUID(int index) {
        assert (this.planUIDs != null) : "planUIDs is null";
        return ((EOValue)this.planUIDs.get(index)).getValue();
    }

    public int getTransferType() {
        assert (this.transfertype == 1 || this.transfertype == 2) : "transfertype is invalid";
        return this.transfertype;
    }

    public void setProjectUid(String newProjectUID) {
        assert (newProjectUID != null) : "newProjectUID is null";
        assert (!newProjectUID.equals("")) : "newProjectUID is invalid";
        this.projectUID = newProjectUID;
    }
}

