/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkedItemDeletion;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.Collection;

public class EOLinkModificationContainer
extends EOEncodableObject {
    private static final String ROLE_INSERT_LINKS = "insertLinks";
    private static final String ROLE_DELETE_LINKS = "deleteLinks";
    private static final String ROLE_DELETED_LINKED_ITEMS = "deletedLinkedItems";
    public static final String XML_NAME = "frame.linkmodificationcontainer";
    public static final String XML_ATTR_PROJECT_UID = "projectUID";
    private String projectUID;
    private EOList<EOLink> insertLinks;
    private EOList<EOLink> deleteLinks;
    private EOList<EOLinkedItemDeletion> deletedLinkedItems;

    public EOLinkModificationContainer(String projectUID) {
        super(XML_NAME);
        this.projectUID = projectUID;
        this.insertLinks = new EOList(ROLE_INSERT_LINKS);
        this.deleteLinks = new EOList(ROLE_DELETE_LINKS);
        this.deletedLinkedItems = new EOList(ROLE_DELETED_LINKED_ITEMS);
    }

    public EOLinkModificationContainer(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.insertLinks = new EOList(ROLE_INSERT_LINKS);
        this.deleteLinks = new EOList(ROLE_DELETE_LINKS);
        this.deletedLinkedItems = new EOList(ROLE_DELETED_LINKED_ITEMS);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, XML_ATTR_PROJECT_UID, this.projectUID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (XML_ATTR_PROJECT_UID.equals(name)) {
            this.projectUID = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return !this.insertLinks.isEmpty() || !this.deleteLinks.isEmpty() || !this.deletedLinkedItems.isEmpty();
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.deleteLinks.writeXMLBody(writeContext, depth);
        this.insertLinks.writeXMLBody(writeContext, depth);
        this.deletedLinkedItems.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            if (ROLE_DELETE_LINKS.equals(list.getRole())) {
                this.deleteLinks = list;
                return true;
            }
            if (ROLE_INSERT_LINKS.equals(list.getRole())) {
                this.insertLinks = list;
                return true;
            }
            if (ROLE_DELETED_LINKED_ITEMS.equals(list.getRole())) {
                this.deletedLinkedItems = list;
                return true;
            }
        }
        return false;
    }

    public EOList<? extends EOLink> getDeleteLinks() {
        return this.deleteLinks;
    }

    public EOList<? extends EOLink> getInsertLinks() {
        return this.insertLinks;
    }

    public boolean isEmpty() {
        return this.getInsertLinks().isEmpty() && this.getDeleteLinks().isEmpty() && this.getDeletedLinkedItems().isEmpty();
    }

    public void setDeleteLinks(Collection<EOLink> deletedLinks) {
        assert (deletedLinks != null) : "deletedLinks must not be null";
        this.deleteLinks = new EOList(deletedLinks, ROLE_DELETE_LINKS);
    }

    public void setInsertLinks(Collection<EOLink> insertedLinks) {
        assert (insertedLinks != null) : "insertedLinks must not be null";
        this.insertLinks = new EOList(insertedLinks, ROLE_INSERT_LINKS);
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public EOList<? extends EOLinkedItemDeletion> getDeletedLinkedItems() {
        return this.deletedLinkedItems;
    }

    public void clearDeletedLinkedItems() {
        this.deletedLinkedItems.clear();
    }

    public void setDeletedLinkedItems(Collection<EOLinkedItemDeletion> linkedItemDeletions) {
        assert (linkedItemDeletions != null) : "linkedItemDeletions must not be null";
        this.deletedLinkedItems = new EOList(linkedItemDeletions, ROLE_DELETED_LINKED_ITEMS);
    }
}

