/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.interFace.IOccurrenceChangeRequest;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PlatformAdapterOccurrenceChangeRequest
implements IOccurrenceChangeRequest {
    private final Set<String> occurenceIDsOfOccurencesToDelete = new HashSet<String>();
    private final Map<String, String> occurenceIDOfOccurencesToCreate_2_occuringCockpitDataUID = new HashMap<String, String>();

    public PlatformAdapterOccurrenceChangeRequest(OccurrenceRelationContribution occRelationContribution, ICollection_<IOccurrenceRepositoryRelationReference> occurenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurenceRelationsToCreate, PlatformAdapterWorkstation workstation) {
        this.setup(occRelationContribution, occurenceRelationsToDelete, occurenceRelationsToCreate, workstation);
    }

    private void setup(OccurrenceRelationContribution occRC, ICollection_<IOccurrenceRepositoryRelationReference> occurenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurenceRelationsToCreate, PlatformAdapterWorkstation platformAdapterWorkstation) {
        String occurenceID;
        IRepositoryPropertySetSample objectID = occRC.getOccurrenceContainingObjectObjectID();
        IRepositoryPropertyType propertyType = occRC.getOccurrenceRCType().getRelatedPropertyType();
        IOccurrenceRepositoryRelationType occurenceRepositoryRelationType = propertyType.getOccuringRelationContributionType().getRelatedRelationType();
        String occurenceContainingObjectUID = platformAdapterWorkstation.getCockpitDataUID(objectID);
        for (IOccurrenceRepositoryRelationReference occurenceRelationToDelete : occurenceRelationsToDelete) {
            occurenceID = occurenceRelationToDelete.getOccurrenceID();
            Assert.checkArgument((occurenceRepositoryRelationType.getOccurrenceRelationContributionType().getRelatedPropertyType() == propertyType ? 1 : 0) != 0, (String)"A passed occurence is not related to the passed property type.");
            String objectIDofOccurenceContainingObject = platformAdapterWorkstation.getCockpitDataUID(occurenceRelationToDelete.getObjectIDofOccurrenceContainingObject());
            Assert.checkArgument((boolean)objectIDofOccurenceContainingObject.equals(occurenceContainingObjectUID), (String)"A passed occurence is not related to the passed property.");
            this.addOccurrenceToDelete(occurenceID);
        }
        for (IOccurrenceRepositoryRelationSample occurenceRelationToCreate : occurenceRelationsToCreate) {
            occurenceID = occurenceRelationToCreate.getOccurrenceID();
            String objectIDofOccuringObject = platformAdapterWorkstation.getCockpitDataUID(occurenceRelationToCreate.getObjectIDofOccuringObject());
            Assert.checkArgument((occurenceRepositoryRelationType.getOccurrenceRelationContributionType().getRelatedPropertyType() == propertyType ? 1 : 0) != 0, (String)"A passed occurence is not related to the passed property type.");
            String objectIDofOccurenceContainingObject = platformAdapterWorkstation.getCockpitDataUID(occurenceRelationToCreate.getObjectIDofOccurrenceContainingObject());
            Assert.checkArgument((boolean)objectIDofOccurenceContainingObject.equals(occurenceContainingObjectUID), (String)"A passed occurence is not related to the passed property.");
            this.addOccurrenceToCreate(occurenceID, objectIDofOccuringObject);
        }
    }

    private void addOccurrenceToDelete(String occurenceID) {
        Assert.checkArgument((!this.occurenceIDsOfOccurencesToDelete.contains(occurenceID) ? 1 : 0) != 0);
        this.occurenceIDsOfOccurencesToDelete.add(occurenceID);
    }

    private void addOccurrenceToCreate(String occurenceID, String occuringCockpitDataUID) {
        Assert.checkArgument((!this.occurenceIDOfOccurencesToCreate_2_occuringCockpitDataUID.containsKey(occurenceID) ? 1 : 0) != 0);
        this.occurenceIDOfOccurencesToCreate_2_occuringCockpitDataUID.put(occurenceID, occuringCockpitDataUID);
    }

    @Override
    public Set<String> getOccurrenceIDsOfOccurencesToDelete() {
        return this.occurenceIDsOfOccurencesToDelete;
    }

    @Override
    public Map<String, String> getOccurrenceIDOfOccurencesToCreate_2_occuringCockpitDataUID() {
        return this.occurenceIDOfOccurencesToCreate_2_occuringCockpitDataUID;
    }
}

