/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.log;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainerEncoder;
import com.arcway.cockpit.frame.shared.dump.IBaseDumpLogFileProcessor;
import com.arcway.cockpit.modulelib2.client.migration.log.DumpLogFileEncoder;
import com.arcway.cockpit.modulelib2.client.migration.log.IDumpLogMigrator;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.OutputStream;

public class AbstractDumpLogMigrator<SE extends EncodableObjectBase, SC extends EncodableObjectBase, TE extends EncodableObjectBase, TC extends EOEncodableObject>
implements IBaseDumpLogFileProcessor<SE> {
    private final DumpLogFileEncoder<TE, TC> dumpLogFileEncoder;
    private final IDumpLogMigrator<SE, SC, TE, TC> dumpLogMigrator;
    private final ElementInitializer<TE> elementInitializer;
    private String newDataTypeID = null;
    private IDumpLogMigrator.IIsInterested iisInterested = null;
    private EOModuleDataContainerEncoder<TE, TC> currentModuleDataContainerEncoder = null;

    public AbstractDumpLogMigrator(OutputStream file, IDumpLogMigrator<SE, SC, TE, TC> dumpLogMigrator, DumpLogFileEncoder.ContainerFactory<TC> containerFactory, ElementInitializer<TE> elementInitializer) throws EXEncoderException {
        this.dumpLogFileEncoder = new DumpLogFileEncoder(file, containerFactory);
        this.dumpLogMigrator = dumpLogMigrator;
        this.elementInitializer = elementInitializer;
    }

    public void nextModuleDataContainer(String dataTypeUID) throws EXEncoderException {
        this.endCurrentModuleDataContainer();
        this.iisInterested = this.dumpLogMigrator.isInterestedInContainer(dataTypeUID);
        if (this.iisInterested instanceof IDumpLogMigrator.IsInterested) {
            IDumpLogMigrator.IsInterested isInterested = (IDumpLogMigrator.IsInterested)this.iisInterested;
            this.newDataTypeID = isInterested.getDataTypeUID();
        } else {
            this.newDataTypeID = dataTypeUID;
        }
        this.currentModuleDataContainerEncoder = this.dumpLogFileEncoder.beginModuleDataContainer(this.newDataTypeID);
    }

    public void nextItem(SE item) throws EXEncoderException {
        TE migratedItem;
        if (this.iisInterested instanceof IDumpLogMigrator.IsInterested) {
            migratedItem = this.dumpLogMigrator.migrateModuleData(item);
            if (migratedItem != null) {
                this.elementInitializer.setDatatypeUID(migratedItem, this.newDataTypeID);
            }
        } else {
            IDumpLogMigrator.IsNotInterested isNotInterested = (IDumpLogMigrator.IsNotInterested)this.iisInterested;
            migratedItem = isNotInterested.getItemConverter().getConvertedItem(item);
        }
        if (migratedItem != null) {
            this.currentModuleDataContainerEncoder.writeItem(migratedItem);
        }
    }

    public void end() throws EXEncoderException {
        this.endCurrentModuleDataContainer();
        this.dumpLogMigrator.addFurtherModuleDataContainers(this.dumpLogFileEncoder);
        this.dumpLogFileEncoder.end();
    }

    private void endCurrentModuleDataContainer() throws EXEncoderException {
        if (this.currentModuleDataContainerEncoder != null) {
            if (this.iisInterested instanceof IDumpLogMigrator.IsInterested) {
                this.dumpLogMigrator.addFurtherModuleData(this.newDataTypeID, this.currentModuleDataContainerEncoder);
            }
            this.currentModuleDataContainerEncoder.end();
            this.currentModuleDataContainerEncoder = null;
        }
    }

    public static interface ElementInitializer<E extends EncodableObjectBase> {
        public void setDatatypeUID(E var1, String var2);
    }
}

