/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.planeditors.FMCAEditorMgrCommand;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.MultiLineInputDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence
extends FMCAEditorMgrCommand {
    private static final ILogger logger = Logger.getLogger(FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.class);
    private final IPlanElement planElement;
    private final String oldDesc;
    private String newDesc;
    private final String uniqueElementUID;

    public FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence(IExternalPlanEditorControllerExtension controllerExtension, IPlanElement planElement) {
        super(controllerExtension);
        this.planElement = planElement;
        this.oldDesc = planElement.getPlanElementDescription();
        this.uniqueElementUID = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElementOccurence(planElement).getElementUID();
    }

    public boolean canExecuteInGeneral() {
        return true;
    }

    public boolean canExecuteNow() {
        boolean canExecute;
        IUniqueElement uniqueElement = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(this.uniqueElementUID);
        Shell parentShell = this.getPlanEditorControllerExtension().getWorkbenchPage().getWorkbenchWindow().getShell();
        MultiLineInputDialog inputDialog = new MultiLineInputDialog(parentShell, Messages.getString("FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.change_global_element_desc"), Messages.getString("FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.enter_new_name"), this.planElement.getPlanElementDescription(), null);
        int answer = inputDialog.open();
        if (answer == 0) {
            this.newDesc = inputDialog.getValue();
            ArrayList problems = new ArrayList();
            if (uniqueElement instanceof IUniqueElementRW) {
                IUniqueElementRW rw = (IUniqueElementRW)uniqueElement;
                Collection renameProblems = rw.checkGeneralAttributeModificationPermission(rw.getAttributeType(UniqueElementAttributeTypesProvider.ATTRID_DESCRIPTION));
                problems.addAll(renameProblems);
            }
            if (problems.isEmpty()) {
                canExecute = true;
            } else {
                IWorkbenchPage workbenchPage = this.getPlanEditorControllerExtension().getEditorPart().getSite().getPage();
                ModificationProblemsDialog.showModificationProblemsDialog(problems, (Shell)workbenchPage.getWorkbenchWindow().getShell());
                canExecute = false;
            }
        } else {
            canExecute = false;
        }
        return canExecute;
    }

    public boolean makesPlanRelatedChanges() {
        return true;
    }

    public void execute() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                try {
                    IUniqueElement uniqueElement = FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.uniqueElementUID);
                    if (uniqueElement != null && uniqueElement.getDescription().equals(FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.oldDesc)) {
                        FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.changeUE(uniqueElement, FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.newDesc);
                    }
                }
                catch (EXModificationProblem e) {
                    es[0] = e;
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    private void changeUE(IUniqueElement uniqueElement, String descToAssign) throws EXModificationProblem {
        if (uniqueElement != null && uniqueElement instanceof IUniqueElementRW) {
            IUniqueElementRW rw = (IUniqueElementRW)uniqueElement;
            Attribute newAttribute = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(descToAssign, null, null));
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
            rw.requestAttributeModificationPermission(newAttribute, transactionController);
            Collection<IModificationProblem> problems = transactionController.execute();
            if (problems.isEmpty()) {
                try {
                    rw.setAttribute(newAttribute);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            } else {
                throw new EXModificationProblem(problems);
            }
        }
    }

    public boolean canUndoNow() {
        IUniqueElement uniqueElement = this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(this.uniqueElementUID);
        return uniqueElement != null && uniqueElement.getDescription().equals(this.newDesc);
    }

    public void undo() {
        final EXModificationProblem[] es = new EXModificationProblem[1];
        this.getProjectAgent().getPropertyChangesListenerManager().runWithDeferredPropertyChangePropagation(new Runnable(){

            @Override
            public void run() {
                try {
                    IUniqueElement uniqueElement = FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.getProjectAgent().getPlanAgentUniqueElementManager().getUniqueElement(FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.uniqueElementUID);
                    FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.changeUE(uniqueElement, FMCAEditorMgrCommandChangeDescriptionOfUEOccurrence.this.oldDesc);
                }
                catch (EXModificationProblem e) {
                    es[0] = e;
                }
            }
        });
        if (es[0] != null) {
            ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(es[0].getModificationProblems(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            problemsDialog.open();
        }
    }

    public void redo() {
        this.execute();
    }
}

