/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOSection_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.MigratorHelper_V0;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ProjectMetaDataMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.projectmetadatamigrator";
    private static final MultiplexEncodableObjectFactory EO_FACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()});
    private static final String OLD_NAME_ATTRIB_ID = "projectname";
    private static final String OLD_DESCRIPTION_ATTRIB_ID = "description";
    private static final String PROJECT_ATTRIB_PREFIX = "frame.project.";
    private static final String NAME_ATTRIB_HUMANREADABLE_ID = "name";
    private static final String DESCRIPTION_ATTRIB_HUMANREADABLE_ID = "description";
    private static final String LANGUAGE_ATTRIB_HUMANREADABLE_ID = "language";
    private static final String COPYRIGHT_ATTRIB_HUMANREADABLE_ID = "copyright";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return EO_FACTORY;
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            for (EOProject_V0 currentProject : projects) {
                EncodableObjectBase sectionData;
                try {
                    sectionData = historicView.readDataFile(currentProject, "sections.xml", null, (IEncodableObjectFactory)EO_FACTORY);
                }
                catch (EXDecoderException e) {
                    throw new MigrationFailedException(e);
                }
                this.handleProjectMetaData(currentProject, sectionData);
            }
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTorACP(projectFile);
    }

    private void migrateACTorACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            EOProject_V0 currentProject = projectFileView_3_.getProjectMetaData();
            EOList<? extends EncodableObjectBase> sections = projectFileView_3_.getDataList("sections");
            this.handleProjectMetaData(currentProject, (EncodableObjectBase)sections);
        }
        catch (ProjectFileAccess.ProjectFileAccessException e) {
            throw new MigrationFailedException(e);
        }
    }

    private void handleProjectMetaData(EOProject_V0 currentProject, EncodableObjectBase sectionData) throws MigrationFailedException {
        String oldName = currentProject.getOldAttributeValue(OLD_NAME_ATTRIB_ID);
        String oldDescription = currentProject.getOldAttributeValue("description");
        if (oldName != null) {
            currentProject.addAttribute(this.generateAttribute(oldName, NAME_ATTRIB_HUMANREADABLE_ID));
            currentProject.clearOldAttribute(OLD_NAME_ATTRIB_ID);
        }
        if (oldDescription != null) {
            currentProject.addAttribute(this.generateAttribute(oldDescription, "description"));
            currentProject.clearOldAttribute("description");
        }
        if (this.getAttibuteOfType("frame.project.language", currentProject.getAttributes()) == null) {
            String language = this.getLanguage(sectionData);
            currentProject.addAttribute(this.generateAttribute(language, LANGUAGE_ATTRIB_HUMANREADABLE_ID));
        }
        if (this.getAttibuteOfType("frame.project.copyright", currentProject.getAttributes()) == null) {
            currentProject.addAttribute(this.generateAttribute("unknown", COPYRIGHT_ATTRIB_HUMANREADABLE_ID));
        }
    }

    private EOAttribute_V0 generateAttribute(String oldValue, String humanreadableID) {
        EOAttribute_V0 nameAttrib = new EOAttribute_V0();
        EOAttributeTypeID_V0 nameAttribTypeID = new EOAttributeTypeID_V0(PROJECT_ATTRIB_PREFIX + humanreadableID, humanreadableID);
        nameAttrib.setAttributeTypeID(nameAttribTypeID);
        EOString nameValueAsEO = new EOString(oldValue);
        nameAttrib.setValueAsEO((EOEncodableObject)nameValueAsEO);
        return nameAttrib;
    }

    private EOAttribute_V0 getAttibuteOfType(String attributeTypeUID, Collection<EOAttribute_V0> attributes) {
        for (EOAttribute_V0 attribute : attributes) {
            String attribTypeUID = attribute.getAttributeTypeUID().getUID();
            if (!attribTypeUID.equals(attributeTypeUID)) continue;
            return attribute;
        }
        return null;
    }

    private String getLanguage(EncodableObjectBase encodableObject) throws MigrationFailedException {
        String projectLanguage = null;
        if (encodableObject != null && encodableObject instanceof EOList) {
            EOList sectionsList = (EOList)encodableObject;
            for (Object o : sectionsList) {
                if (o instanceof EOSection_V0) {
                    EOSection_V0 currentSection = (EOSection_V0)((Object)o);
                    if (!MigratorHelper_V0.isRootSection(currentSection)) continue;
                    String descriptionAttribute = MigratorHelper_V0.getStringAttribute(currentSection, "frame.section.description", "description");
                    projectLanguage = this.getLanguageValue(descriptionAttribute);
                    break;
                }
                throw new MigrationFailedException("The sections list contains elements not of expected type EOSection_V0: " + o.getClass().getName());
            }
        } else {
            throw new MigrationFailedException("The file sections.xml does not exist or contains elements not of expected type EOSection_V0.");
        }
        return projectLanguage;
    }

    private String getLanguageValue(String valueToCheck) {
        if (valueToCheck.startsWith("Wurzelverzeichnis")) {
            return "de";
        }
        return "en";
    }
}

