/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.Messages;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFrameData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FrameDataMetaAttributesMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.metaattributesmigrator";
    private static final ILogger logger = Logger.getLogger(FrameDataMetaAttributesMigrator.class);
    private static final String FRAME_DATA_META_ATTRIBUTE_PREFIX = "framedata.";
    private static final String CREATOR_HUMANREADABLE_ID = "creator";
    private static final String CREATOR_UID = "framedata.creator";
    private static final String CREATION_DATE_HUMANREADABLE_ID = "creationDate";
    private static final String CREATION_DATE_UID = "framedata.creationDate";
    private static final String LAST_EDITOR_HUMANREADABLE_ID = "lastEditor";
    private static final String LAST_EDITOR_UID = "framedata.lastEditor";
    private static final String LAST_EDIT_DATE_HUMANREADABLE_ID = "lastEditDate";
    private static final String LAST_EDIT_DATE_UID = "framedata.lastEditDate";
    private static final String OLD_PLAN_ATTRIBUTE_PREFIX = "frame.plan.";
    private static final String OLD_ATTRID_CREATOR_UID = "frame.plan.creator";
    private static final String OLD_ATTRID_CREATION_DATE_UID = "frame.plan.creationDate";
    private static final String OLD_ATTRID_LAST_EDITOR_UID = "frame.plan.lastEditor";
    private static final String OLD_ATTRID_LAST_EDIT_DATE_UID = "frame.plan.lastEditDate";
    private static final String IMPORT_DATE = "";
    private static final String USER_NAME = Messages.getString("FrameDataMetaAttributesMigrator.UserName");
    private static final ArrayList<String> EO_LIST_TAGS = new ArrayList();
    private static final ArrayList<String> FRAME_DATA_PROJECT_DUMP_FILE_NAMES;
    private static final ArrayList<String> META_ATTRIBUTES_TYPE_ID_UIDS;

    static {
        EO_LIST_TAGS.add("stakeholders");
        EO_LIST_TAGS.add("stakeholder roles");
        EO_LIST_TAGS.add("sections");
        EO_LIST_TAGS.add("unique elements");
        EO_LIST_TAGS.add("metadata");
        EO_LIST_TAGS.add(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE);
        EO_LIST_TAGS.add(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE);
        EO_LIST_TAGS.add(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER);
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES = new ArrayList();
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES.add("Stakeholders.xml");
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES.add("sections.xml");
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES.add("plans.xml");
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES.add("uniqueElements.xml");
        FRAME_DATA_PROJECT_DUMP_FILE_NAMES.add("frameData.xml");
        META_ATTRIBUTES_TYPE_ID_UIDS = new ArrayList();
        META_ATTRIBUTES_TYPE_ID_UIDS.add(CREATOR_UID);
        META_ATTRIBUTES_TYPE_ID_UIDS.add(CREATION_DATE_UID);
        META_ATTRIBUTES_TYPE_ID_UIDS.add(LAST_EDITOR_UID);
        META_ATTRIBUTES_TYPE_ID_UIDS.add(LAST_EDIT_DATE_UID);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version3.reporttemplaterootfoldermigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            for (EOList dataList : projectFileView_3_.getMainData()) {
                if (EO_LIST_TAGS.contains(dataList.getRole())) {
                    for (EncodableObjectBase element : dataList) {
                        if (element instanceof EOFrameData_V0) {
                            EOFrameData_V0 eoFrameData = (EOFrameData_V0)element;
                            this.addMetaAttributes(eoFrameData);
                            continue;
                        }
                        throw new MigrationFailedException("The data list of the project file " + dataList.getRole() + " contains elements not of expected type EOFrameData_V0: " + element.getClass().getName());
                    }
                    continue;
                }
                if (!dataList.getRole().equals("plans")) continue;
                for (EncodableObjectBase element : dataList) {
                    if (element instanceof EOPlan_V0) {
                        EOPlan_V0 eoPlan = (EOPlan_V0)element;
                        this.migrateEOPlan(eoPlan);
                        continue;
                    }
                    throw new MigrationFailedException("The data list of the project file " + dataList.getRole() + " contains elements not of expected type EOPlan_V0: " + element.getClass().getName());
                }
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> dataList = projectFileView_3_.getDataList("plans");
            if (dataList != null) {
                for (EncodableObjectBase element : dataList) {
                    if (element instanceof EOPlan_V0) {
                        EOPlan_V0 eoPlan = (EOPlan_V0)element;
                        this.migrateEOPlan(eoPlan);
                        continue;
                    }
                    throw new MigrationFailedException("The data list of the project file " + dataList.getRole() + " contains elements not of expected type EOPlan_V0: " + element.getClass().getName());
                }
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            for (EOProject_V0 currentProject : projects) {
                for (String frameDataFileName : FRAME_DATA_PROJECT_DUMP_FILE_NAMES) {
                    this.migrateProjectDump(frameDataFileName, historicView, currentProject);
                }
            }
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migrateProjectDump(String fileName, HistoricProjectDumpView_3_ historicView, EOProject_V0 currentProject) throws MigrationFailedException {
        block9: {
            try {
                EncodableObjectBase frameDataBase = historicView.readDataFile(currentProject, fileName, null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), PSCPlainMessageDataFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
                if (frameDataBase != null && frameDataBase instanceof EOList) {
                    if (fileName.equals("plans.xml")) {
                        EOList dataList = (EOList)frameDataBase;
                        for (Object o : dataList) {
                            if (o instanceof EOPlan_V0) {
                                EOPlan_V0 eoPlan = (EOPlan_V0)((Object)o);
                                this.migrateEOPlan(eoPlan);
                                continue;
                            }
                            throw new MigrationFailedException("The file " + fileName + " contains elements not of expected type EOPLan_V0: " + o.getClass().getName());
                        }
                    } else {
                        EOList dataList = (EOList)frameDataBase;
                        for (Object o : dataList) {
                            if (o instanceof EOFrameData_V0) {
                                EOFrameData_V0 frameData = (EOFrameData_V0)((Object)o);
                                this.addMetaAttributes(frameData);
                                continue;
                            }
                            throw new MigrationFailedException("The file " + fileName + " contains elements not of expected type EOFrameData_V0: " + o.getClass().getName());
                        }
                    }
                    historicView.writeDataFile(currentProject, fileName, null, frameDataBase);
                    break block9;
                }
                throw new MigrationFailedException("The file " + fileName + " does not exist or contains elements not of expected type EOList.");
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
        }
    }

    private void addMetaAttributes(EOFrameData_V0 eoFrameData) {
        EOString importDate = new EOString(IMPORT_DATE);
        EOString importUser = new EOString(USER_NAME);
        EOAttribute_V0 creator = new EOAttribute_V0();
        creator.setAttributeTypeID(new EOAttributeTypeID_V0(CREATOR_UID, CREATOR_HUMANREADABLE_ID));
        creator.setValueAsEO((EOEncodableObject)importUser);
        EOAttribute_V0 creationDate = new EOAttribute_V0();
        creationDate.setAttributeTypeID(new EOAttributeTypeID_V0(CREATION_DATE_UID, CREATION_DATE_HUMANREADABLE_ID));
        creationDate.setValueAsEO((EOEncodableObject)importDate);
        EOAttribute_V0 lastEditor = new EOAttribute_V0();
        lastEditor.setAttributeTypeID(new EOAttributeTypeID_V0(LAST_EDITOR_UID, LAST_EDITOR_HUMANREADABLE_ID));
        lastEditor.setValueAsEO((EOEncodableObject)importUser);
        EOAttribute_V0 lastEditDate = new EOAttribute_V0();
        lastEditDate.setAttributeTypeID(new EOAttributeTypeID_V0(LAST_EDIT_DATE_UID, LAST_EDIT_DATE_HUMANREADABLE_ID));
        lastEditDate.setValueAsEO((EOEncodableObject)importDate);
        eoFrameData.addAttribute(creator);
        eoFrameData.addAttribute(creationDate);
        eoFrameData.addAttribute(lastEditor);
        eoFrameData.addAttribute(lastEditDate);
    }

    private void migrateEOPlan(EOPlan_V0 eoPlan) {
        ArrayList<String> handledAttributeTypes = new ArrayList<String>(eoPlan.getAttributes().size() * 2);
        ArrayList<EOAttribute_V0> attributesToAdd = new ArrayList<EOAttribute_V0>();
        Iterator<EOAttribute_V0> itEOAttribute = eoPlan.getAttributes().iterator();
        while (itEOAttribute.hasNext()) {
            EOAttribute_V0 eoAttribute = itEOAttribute.next();
            if (eoAttribute.getAttributeTypeUID().getUID().equals(OLD_ATTRID_CREATOR_UID)) {
                EOAttribute_V0 creator = new EOAttribute_V0();
                creator.setAttributeTypeID(new EOAttributeTypeID_V0(CREATOR_UID, CREATOR_HUMANREADABLE_ID));
                creator.setValueAsEO((EOEncodableObject)this.getUserName((EncodableObjectBase)eoAttribute.getValueAsEO()));
                attributesToAdd.add(creator);
                itEOAttribute.remove();
                handledAttributeTypes.add(CREATOR_UID);
                continue;
            }
            if (eoAttribute.getAttributeTypeUID().getUID().equals(OLD_ATTRID_CREATION_DATE_UID)) {
                EOAttribute_V0 creationDate = new EOAttribute_V0();
                creationDate.setAttributeTypeID(new EOAttributeTypeID_V0(CREATION_DATE_UID, CREATION_DATE_HUMANREADABLE_ID));
                creationDate.setValueAsEO(eoAttribute.getValueAsEO());
                attributesToAdd.add(creationDate);
                itEOAttribute.remove();
                handledAttributeTypes.add(CREATION_DATE_UID);
                continue;
            }
            if (eoAttribute.getAttributeTypeUID().getUID().equals(OLD_ATTRID_LAST_EDITOR_UID)) {
                EOAttribute_V0 lastEditor = new EOAttribute_V0();
                lastEditor.setAttributeTypeID(new EOAttributeTypeID_V0(LAST_EDITOR_UID, LAST_EDITOR_HUMANREADABLE_ID));
                lastEditor.setValueAsEO((EOEncodableObject)this.getUserName((EncodableObjectBase)eoAttribute.getValueAsEO()));
                attributesToAdd.add(lastEditor);
                itEOAttribute.remove();
                handledAttributeTypes.add(LAST_EDITOR_UID);
                continue;
            }
            if (eoAttribute.getAttributeTypeUID().getUID().equals(OLD_ATTRID_LAST_EDIT_DATE_UID)) {
                EOAttribute_V0 lastEditDate = new EOAttribute_V0();
                lastEditDate.setAttributeTypeID(new EOAttributeTypeID_V0(LAST_EDIT_DATE_UID, LAST_EDIT_DATE_HUMANREADABLE_ID));
                lastEditDate.setValueAsEO(eoAttribute.getValueAsEO());
                attributesToAdd.add(lastEditDate);
                itEOAttribute.remove();
                handledAttributeTypes.add(LAST_EDIT_DATE_UID);
                continue;
            }
            handledAttributeTypes.add(eoAttribute.getAttributeTypeUID().getUID());
        }
        for (EOAttribute_V0 attributeToAdd : attributesToAdd) {
            eoPlan.addAttribute(attributeToAdd);
        }
        if (!handledAttributeTypes.containsAll(META_ATTRIBUTES_TYPE_ID_UIDS)) {
            this.addMetaAttributes(eoPlan);
        }
    }

    private EOString getUserName(EncodableObjectBase eoValue) {
        EOString userName;
        if (eoValue instanceof EOUser) {
            EOUser eoUser = (EOUser)eoValue;
            userName = new EOString(eoUser.getDisplayName());
        } else {
            userName = new EOString(USER_NAME);
        }
        return userName;
    }
}

