/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_dumps.version0;

import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOStakeholder_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IDataFileMigrator;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.ProjectDumpFileAccess_ForClient;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.IXMLFileProcessor;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.SimplyDecodingXMLFileProcessor;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.encoding.sequential.processing.EOConcatenatingContainerReader;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricProjectDumpView_0_
implements IHistoricProjectDumpView {
    private static final ILogger logger = Logger.getLogger(HistoricProjectDumpView_0_.class);
    public static final String FILENAME_PROJECTS = "projects.xml";
    public static final String FILENAME_STAKEHOLDERS = "Stakeholders.xml";
    public static final String FILENAME_STAKEHOLDER_ROLES = "Roles.xml";
    public static final String FILENAME_STAKEHOLDER_ROLE_LINK = "StakeholdersRoles.xml";
    public static final String FILENAME_SECTIONS = "sections.xml";
    public static final String FILENAME_PLANS = "plans.xml";
    public static final String FILENAME_FRAME_DATA = "frameData.xml";
    public static final String FILENAME_UNIQUE_ELEMENTS = "uniqueElements.xml";
    public static final String FILENAME_UNIQUE_ELEMENT_OCCURRENCES = "uniqueElementOccurences.xml";
    public static final String FILENAME_UNIQUE_ELEMENT_RELATIONSHIPS = "uniqueElementRelationships.xml";
    public static final String FILENAME_LINKS = "links.xml";
    public static final String FILENAME_PERMISSIONS = "permissions.xml";
    public static final String FILENAME_USER_DEFINED_ATTRIBUTE_TYPES = "userDefinedAttributeTypes.xml";
    public static final String FILENAME_SECTIONS_AND_PLANS = "sectionsAndPlans.xml";
    public static final String FILENAME_COMMIT_INFORMATION = "commitInformation.xml";
    public static final String FILENAME_MODIFICATION_LOG = "modificationLog.xml";
    public static final String FILENAME_OLD_LAST_COMMIT_INFORMATION = "lastCommitInformation.xml";
    public static final String FILENAME_COMMON_MODULEDATA = "cmm_data.xml";
    public static final String FILENAME_COMMON_MODULEDATALOG = "cmm_data_log.xml";
    public static final String MODULE_ID_MODULELIB2 = "cmm";
    public static final String FILES_DUMP_DIRECTORY = "files";
    public static final String FILE_TYPE_FILE = "file";
    public static final String FILE_TYPE_IMAGE = "image";
    public static final String FILE_VERSIONS_FILE_NAME_OLD = "versions";
    public static final String FILE_VERSIONS_FILE_NAME = "versions1";
    public static final String CONCRETE_FILE_DIRECTORY_PREFIX = "versions_";
    public static final String OLD_PLAN_FILES_DIRECTORY = "plans";
    public static final String OLD_PLAN_VERSIONS_FILE = "history.xml";
    private static final XMLDecoder xmlDecoder = new XMLDecoder();
    private final ProjectDumpFileAccess_ForClient projectDump;
    private EOList<EOProject_V0> projects;
    private final Map<EOProject_V0, EOLinkDataContainer_V0> map_project_links = new HashMap<EOProject_V0, EOLinkDataContainer_V0>();
    private final Map<EOProject_V0, EOList<EOPermission>> map_project_permissions = new HashMap<EOProject_V0, EOList<EOPermission>>();

    public HistoricProjectDumpView_0_(ProjectDumpFileAccess_ForClient projectDump) {
        this.projectDump = projectDump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EOProject_V0> getAllProjects() throws MigrationFailedException {
        if (this.projects == null) {
            File projectsFile = new File(this.projectDump.getRootDirectoryOfUnzippedProjectDumpFile(), FILENAME_PROJECTS);
            XMLDecoder xMLDecoder = xmlDecoder;
            synchronized (xMLDecoder) {
                try {
                    this.projects = (EOList)xmlDecoder.decodeXML((InputStream)new FileInputStream(projectsFile), (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}), true);
                }
                catch (EXDecoderException eDE) {
                    logger.error("Cannot retrieve projects list from project dump.", (Throwable)eDE);
                    throw new MigrationFailedException("Invalid project dump file: projects file could not be parsed");
                }
                catch (FileNotFoundException fnfE) {
                    logger.error("Cannot retrieve projects list from project dump.", (Throwable)fnfE);
                    throw new MigrationFailedException("Invalid project dump file: projects file could not be found (projects.xml)");
                }
            }
        }
        return this.projects;
    }

    public File getProjectDirectory(EOProject_V0 project) {
        File projectRootDirectory = new File(this.projectDump.getRootDirectoryOfUnzippedProjectDumpFile(), project.getProjectUID());
        if (projectRootDirectory.exists() && projectRootDirectory.isDirectory()) {
            File projectFrameDirectory = new File(projectRootDirectory, "frame");
            if (projectFrameDirectory.exists() && projectFrameDirectory.isDirectory()) {
                return projectFrameDirectory;
            }
            logger.warn("No frame sub directory in project directory of project " + project.getUID() + ".");
            return null;
        }
        logger.warn("No project directory of project " + project.getUID() + ".");
        return null;
    }

    public void migrateDataFile(EOProject_V0 project, final String fileName, String moduleID, final IEncodableObjectFactory eoFactory, final IDataFileMigrator dataFileMigrator) throws EXDecoderException {
        this.processDataFile(project, fileName, moduleID, new IXMLFileProcessor<Object>(){

            public Object process(File sourceFile) throws JvmExternalResourceInteractionException, EXDecoderException {
                File tempFile = SessionTempDirectoryManager.createSessionTempFile((String)fileName, (String)".tmp");
                InputStream inputStream = FileHelper.fileToInputStream((File)sourceFile);
                try {
                    OutputStream outputStream = FileHelper.fileToOutputStream((File)tempFile);
                    try {
                        EOConcatenatingContainerReader<? extends EncodableObjectBase, ? extends EncodableObjectBase> dataFileReader;
                        try {
                            dataFileReader = dataFileMigrator.getDataFileReader(outputStream);
                        }
                        catch (EXEncoderException e) {
                            e.toNewRuntimeException(null);
                            throw new JvmExternalResourceInteractionException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        dataFileReader.readContainer(inputStream, xmlDecoder, eoFactory);
                    }
                    finally {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            logger.error("error while closing stream", (Throwable)e);
                        }
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("error while closing stream", (Throwable)e);
                    }
                }
                DataCopyHelper.copyFile((File)tempFile, (File)sourceFile);
                FileHelper.deleteExistingFileOrDirectory((File)tempFile);
                return null;
            }
        });
    }

    public void readDataFile(EOProject_V0 project, String fileName, String moduleID, final IEncodableObjectFactory eoFactory, final EOConcatenatingContainerReader<? extends EncodableObjectBase, ? extends EncodableObjectBase> dataFileReader) throws EXDecoderException {
        this.processDataFile(project, fileName, moduleID, new IXMLFileProcessor<Object>(){

            public Object process(File sourceFile) throws JvmExternalResourceInteractionException, EXDecoderException {
                InputStream inputStream = FileHelper.fileToInputStream((File)sourceFile);
                try {
                    dataFileReader.readContainer(inputStream, xmlDecoder, eoFactory);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("error while closing stream", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    public EncodableObjectBase readDataFile(EOProject_V0 project, String fileName, String moduleID, IEncodableObjectFactory eoFactory) throws EXDecoderException {
        return (EncodableObjectBase)this.processDataFile(project, fileName, moduleID, (IXMLFileProcessor)new SimplyDecodingXMLFileProcessor(xmlDecoder, eoFactory));
    }

    private <R> R processDataFile(EOProject_V0 project, String fileName, String moduleID, IXMLFileProcessor<R> fileProcessor) throws EXDecoderException {
        return this.processDataFile(project, fileName, moduleID, true, fileProcessor);
    }

    public EncodableObjectBase readDataFile(EOProject_V0 project, String fileName, String moduleID, IEncodableObjectFactory eoFactory, boolean logMissingFile) throws EXDecoderException {
        return (EncodableObjectBase)this.processDataFile(project, fileName, moduleID, logMissingFile, (IXMLFileProcessor)new SimplyDecodingXMLFileProcessor(xmlDecoder, eoFactory));
    }

    private <R> R processDataFile(EOProject_V0 project, String fileName, String moduleID, boolean logMissingFile, IXMLFileProcessor<R> fileProcessor) throws EXDecoderException {
        File projectDirectory = this.getProjectDirectory(project);
        if (projectDirectory != null) {
            File directory = moduleID != null ? new File(projectDirectory, moduleID) : projectDirectory;
            return this.processDataFile(directory, fileName, logMissingFile, fileProcessor);
        }
        return null;
    }

    public EncodableObjectBase readDataFile(File directory, String fileName, IEncodableObjectFactory eoFactory) throws EXDecoderException {
        return (EncodableObjectBase)this.processDataFile(directory, fileName, (IXMLFileProcessor)new SimplyDecodingXMLFileProcessor(xmlDecoder, eoFactory));
    }

    private <R> R processDataFile(File directory, String fileName, IXMLFileProcessor<R> fileProcessor) throws EXDecoderException {
        return this.processDataFile(directory, fileName, true, fileProcessor);
    }

    public EncodableObjectBase readDataFile(File directory, String fileName, IEncodableObjectFactory eoFactory, boolean logMissingFile) throws EXDecoderException {
        return (EncodableObjectBase)this.processDataFile(directory, fileName, logMissingFile, (IXMLFileProcessor)new SimplyDecodingXMLFileProcessor(xmlDecoder, eoFactory));
    }

    private <R> R processDataFile(File directory, String fileName, boolean logMissingFile, IXMLFileProcessor<R> fileProcessor) throws EXDecoderException {
        if (directory.exists()) {
            File dataFile = new File(directory, fileName);
            if (dataFile.exists()) {
                try {
                    return (R)fileProcessor.process(dataFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.warn("Data file '" + fileName + "' within the specified directory '" + directory.getPath() + "' exists, but a JvmExternalResourceInteractionException was thrown when trying to process it.", (Throwable)e);
                    throw new EXDecoderException((Throwable)e);
                }
            }
            if (logMissingFile) {
                logger.warn("Data file '" + fileName + "' within the specified directory '" + directory.getPath() + "' does not exist in the project dump.");
            }
            return null;
        }
        if (logMissingFile) {
            logger.warn("The specified directory '" + directory.getPath() + "' does not exist in the project dump.");
        }
        return null;
    }

    public EOLinkDataContainer_V0 readLinks(EOProject_V0 project) throws EXDecoderException {
        if (this.map_project_links.get((Object)project) == null) {
            this.map_project_links.put(project, (EOLinkDataContainer_V0)this.readDataFile(project, FILENAME_LINKS, null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()})));
        }
        return this.map_project_links.get((Object)project);
    }

    public EOList<EOPermission> readPermissions(EOProject_V0 project) throws EXDecoderException {
        if (this.map_project_permissions.get((Object)project) == null) {
            this.map_project_permissions.put(project, (EOList<EOPermission>)((EOList)this.readDataFile(project, FILENAME_PERMISSIONS, null, (IEncodableObjectFactory)PSCPlainMessageDataFactory.getDefault())));
        }
        return this.map_project_permissions.get((Object)project);
    }

    public EOList<EOStakeholder_V0> readStakeholders(EOProject_V0 project) throws EXDecoderException {
        return (EOList)this.readDataFile(project, FILENAME_STAKEHOLDERS, null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
    }

    public boolean writeDataFile(EOProject_V0 project, String fileName, String moduleID, EncodableObjectBase data) {
        File projectDirectory = this.getProjectDirectory(project);
        if (projectDirectory != null) {
            File dataFileDirectory = moduleID != null ? new File(projectDirectory, moduleID) : projectDirectory;
            return this.writeDataFile(dataFileDirectory, fileName, data);
        }
        return false;
    }

    public boolean writeDataFile(File directory, String fileName, EncodableObjectBase data) {
        try {
            FileHelper.ensureDirectoryExistance((File)directory);
            File dataFile = new File(directory, fileName);
            if (dataFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory((File)dataFile);
            }
            data.writeToFile(dataFile);
            return true;
        }
        catch (IOException ioE) {
            logger.warn("Can't write data into file '" + fileName + "' within specified directory '" + directory.getPath() + "' in the project dump.");
            return false;
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Can't write data into file '" + fileName + "' within specified directory '" + directory.getPath() + "' in the project dump.");
            return false;
        }
    }

    private boolean writeLinks(EOProject_V0 project, EOLinkDataContainer_V0 linkData) {
        return this.writeDataFile(project, FILENAME_LINKS, null, (EncodableObjectBase)linkData);
    }

    private boolean writePermissions(EOProject_V0 project, EOList<EOPermission> permissionData) {
        return this.writeDataFile(project, FILENAME_PERMISSIONS, null, (EncodableObjectBase)permissionData);
    }

    public boolean deleteDataDirectory(EOProject_V0 project, String moduleID) {
        try {
            File moduleDirectory;
            File projectDirectory = this.getProjectDirectory(project);
            if (projectDirectory != null && (moduleDirectory = new File(projectDirectory, moduleID)).exists() && moduleDirectory.isDirectory()) {
                FileHelper.deleteExistingFileOrDirectory((File)moduleDirectory);
                return true;
            }
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Can't delete obsolete directory '" + moduleID + "' in the project dump.", (Throwable)jeriE);
        }
        return false;
    }

    @Override
    public void closeView() throws DumpFileAccessException {
        if (this.projects != null) {
            File file = this.projectDump.getRootDirectoryOfUnzippedProjectDumpFile();
            if (file != null) {
                try {
                    File projectsFile = new File(file, FILENAME_PROJECTS);
                    if (projectsFile.exists()) {
                        FileHelper.deleteExistingFileOrDirectory((File)projectsFile);
                    }
                    XMLFileAccessor projectsXMLFileAccessor = new XMLFileAccessor(projectsFile, null);
                    projectsXMLFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOProject_V0>>(){

                        public EOList<EOProject_V0> getFileContent() {
                            return HistoricProjectDumpView_0_.this.projects;
                        }
                    });
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.error("Exception when writing back projects from project dump.", (Throwable)jeriE);
                    throw new DumpFileAccessException((Exception)((Object)jeriE));
                }
            } else {
                logger.error("Exception when writing back projects from project dump - root directory unavailable.");
            }
        }
        for (Map.Entry<EOProject_V0, EOLinkDataContainer_V0> entry : this.map_project_links.entrySet()) {
            if (entry.getValue() == null) continue;
            this.writeLinks(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<EOProject_V0, EOLinkDataContainer_V0> entry : this.map_project_permissions.entrySet()) {
            if (entry.getValue() == null) continue;
            this.writePermissions(entry.getKey(), (EOList<EOPermission>)((EOList)entry.getValue()));
        }
    }
}

