/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.reportinfo;

import com.arcway.cockpit.frame.client.project.docgenerator.reportinfo.DTReportMetaInfo;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReportMetaInfo {
    private static final ILogger LOGGER = Logger.getLogger(ReportMetaInfo.class);
    public static final String ReportInfoFilename = "cockpit_report_info.xml";
    private static final String COCKPIT_REPORT_INFO_ROOT_XML_TAG = "CockpitReportInfo";
    private final String name;
    private final String type;
    private final String projectName;
    private final long creationMillis;
    private final Collection<String> relativePathNames;
    private File reportDir;

    public ReportMetaInfo(String name, String reporttype, String projectName, long creationMillis, Collection<String> relativePathNames) {
        this.name = name;
        this.type = reporttype;
        this.projectName = projectName;
        this.creationMillis = creationMillis;
        this.relativePathNames = relativePathNames;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public Collection<String> getRelativePathNames() {
        return Collections.unmodifiableCollection(this.relativePathNames);
    }

    private List<File> getFiles() {
        ArrayList<File> result = new ArrayList<File>(this.relativePathNames.size());
        for (String relativePathName : this.relativePathNames) {
            ArrayList filenames = StringUtil.split((String)relativePathName, (char)'/');
            File absolutePath = this.reportDir;
            for (String filename : filenames) {
                absolutePath = new File(absolutePath, filename);
            }
            assert (absolutePath.getAbsolutePath().length() > this.reportDir.getAbsolutePath().length());
            result.add(absolutePath);
        }
        return result;
    }

    private static ReportMetaInfo readReportInfo(File reportDir) {
        File reportInfoFile = new File(reportDir, ReportInfoFilename);
        Error firstError = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(reportInfoFile);
            ReportMetaInfo result = (ReportMetaInfo)XMLCoDecForData.decodeIntoObject((InputStream)is, (IDataType)DTReportMetaInfo.getInstance());
            is = null;
            result.reportDir = reportDir;
            ReportMetaInfo reportMetaInfo = result;
            return reportMetaInfo;
        }
        catch (Error e) {
            firstError = e;
            throw e;
        }
        catch (Throwable th) {
            LOGGER.error("Unable to read report info file located here: \"" + reportInfoFile.getPath() + "\". - " + th.getClass().getName(), th);
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Error e) {
                    if (firstError != null) {
                        throw firstError;
                    }
                    throw e;
                }
                catch (Throwable th) {
                    LOGGER.error("Unable to close report info filestream. - " + th.getClass().getName(), th);
                }
            }
        }
    }

    public static ReportMetaInfo containsReport(File dir) {
        assert (dir.isDirectory());
        File reportInfoFile = new File(dir, ReportInfoFilename);
        if (!reportInfoFile.exists()) {
            return null;
        }
        return ReportMetaInfo.readReportInfo(dir);
    }

    public static void deleteReport(ReportMetaInfo reportMetaInfo) {
        assert (new File(reportMetaInfo.reportDir, ReportInfoFilename).exists());
        for (File reportFile : reportMetaInfo.getFiles()) {
            try {
                if (!reportFile.isDirectory()) {
                    FileHelper.deleteFileOrDirectory((File)reportFile);
                    continue;
                }
                assert (false);
            }
            catch (JvmExternalResourceInteractionException e) {
                LOGGER.error("Unable to delete report file " + reportFile, (Throwable)e);
            }
        }
        File reportInfoFile = new File(reportMetaInfo.reportDir, ReportInfoFilename);
        try {
            FileHelper.deleteFileOrDirectory((File)reportInfoFile);
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.error("Unable to delete report info file " + reportInfoFile, (Throwable)e);
        }
    }

    public static void writeReportInfo(String name, String reporttype, String projectName, long creationMillis, File reportDir, Collection<File> reportFiles) {
        try {
            ArrayList<String> relativePathNames = new ArrayList<String>(reportFiles.size());
            for (File reportFile : reportFiles) {
                if (reportFile.isDirectory()) continue;
                StringBuilder relativePathBuilder = new StringBuilder();
                File f = reportFile;
                while (f != null && !f.equals(reportDir)) {
                    if (relativePathBuilder.length() > 0) {
                        relativePathBuilder.insert(0, "/");
                    }
                    relativePathBuilder.insert(0, f.getName());
                    f = f.getParentFile();
                }
                if (f != null) {
                    relativePathNames.add(relativePathBuilder.toString());
                    continue;
                }
                assert (false);
            }
            ReportMetaInfo reportMetaInfo = new ReportMetaInfo(name, reporttype, projectName, creationMillis, relativePathNames);
            reportMetaInfo.reportDir = new File(reportDir, ReportInfoFilename);
            FileOutputStream reportInfoFileStream = new FileOutputStream(reportMetaInfo.reportDir);
            XMLCoDecForData.encodeIntoOutputStream((OutputStream)reportInfoFileStream, (Object)reportMetaInfo, (IDataType)DTReportMetaInfo.getInstance(), (String)COCKPIT_REPORT_INFO_ROOT_XML_TAG, null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable th) {
            LOGGER.error("Unable to create report info file . - " + th.getClass().getName(), th);
        }
    }
}

