/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.reportinfo;

import com.arcway.cockpit.frame.client.project.docgenerator.reportinfo.ReportMetaInfo;
import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.lib.DTInteger64Bit;
import com.arcway.lib.codec.data.lib.DTString;
import com.arcway.lib.codec.data.lib.generic.AbstractStructuredDataType;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.date.RFC1123DateFormatter;
import java.util.ArrayList;
import java.util.Date;

public class DTReportMetaInfo
extends AbstractStructuredDataType {
    private static final IKey ROLE_NAME = Key.getCanonicalKeyInstance((String)"name");
    private static final IKey ROLE_TYPE = Key.getCanonicalKeyInstance((String)"type");
    private static final IKey ROLE_PROJECT = Key.getCanonicalKeyInstance((String)"projectName");
    private static final IKey ROLE_CREATION_MILLIS = Key.getCanonicalKeyInstance((String)"creationMillis");
    private static final IKey ROLE_CREATION_DATE = Key.getCanonicalKeyInstance((String)"creationDate");
    private static final IKey ROLE_FILE = Key.getCanonicalKeyInstance((String)"file");
    private static DTReportMetaInfo SINGLETON;

    public static synchronized DTReportMetaInfo getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new DTReportMetaInfo();
        }
        return SINGLETON;
    }

    private DTReportMetaInfo() {
        this.addPropertyType(ROLE_NAME, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPropertyType(ROLE_TYPE, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPropertyType(ROLE_PROJECT, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPropertyType(ROLE_CREATION_MILLIS, (IDataType)DTInteger64Bit.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPropertyType(ROLE_CREATION_DATE, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addChildType(ROLE_FILE, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
    }

    protected AbstractStructuredDataType.AbstractStructuredDataFactory createStructuredDataFactory() {
        return new DataFactory();
    }

    public boolean isSet(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    public Object getProperty(Object data, IKey role) {
        Object propertyData;
        ReportMetaInfo typedData = (ReportMetaInfo)data;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_NAME)) {
            propertyData = typedData.getName();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_TYPE)) {
            propertyData = typedData.getType();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECT)) {
            propertyData = typedData.getProjectName();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CREATION_MILLIS)) {
            propertyData = typedData.getCreationMillis();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CREATION_DATE)) {
            propertyData = RFC1123DateFormatter.getRFC1123String((Date)new Date(typedData.getCreationMillis()));
        } else {
            throw new IllegalArgumentException();
        }
        return propertyData;
    }

    public IList_<? extends Object> getChildren(Object data, IKey role) {
        ReportMetaInfo typedData = (ReportMetaInfo)data;
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_FILE)) {
            return new ArrayList_(typedData.getRelativePathNames());
        }
        throw new IllegalArgumentException();
    }

    private static class DataFactory
    extends AbstractStructuredDataType.AbstractStructuredDataFactory {
        private String name;
        private String type;
        private String projectName;
        private long creationMillis;
        private final ArrayList<String> relativePathNames = new ArrayList();

        private DataFactory() {
        }

        public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
            if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_NAME)) {
                this.name = (String)propertyOrChild;
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_TYPE)) {
                this.type = (String)propertyOrChild;
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECT)) {
                this.projectName = (String)propertyOrChild;
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CREATION_MILLIS)) {
                this.creationMillis = (Long)propertyOrChild;
            } else if (!IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_CREATION_DATE)) {
                if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_FILE)) {
                    this.relativePathNames.add((String)propertyOrChild);
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }

        public Object createDataElement() throws EXDataCreationFailed {
            return new ReportMetaInfo(this.name, this.type, this.projectName, this.creationMillis, this.relativePathNames);
        }

        public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
            return false;
        }

        public void setFlag(IKey role) {
            throw new IllegalArgumentException();
        }
    }
}

