/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportOutputtemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.DynamicReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IFileValidator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DocGeneratorManager
implements IFrameDataManager {
    private static final ILogger logger = Logger.getLogger(DocGeneratorManager.class);
    private IFrameProjectAgent projectAgent;
    private static final List<IFrameDocGenerator> docGenerators = new ArrayList<IFrameDocGenerator>();
    private static final Map<String, IReportTemplateType> reportTemplateTypes = new HashMap<String, IReportTemplateType>();
    private static final Map<String, IReportOutputTemplateType> reportOutputTemplateTypes = new HashMap<String, IReportOutputTemplateType>();
    private static final Map<String, IReportOutputFormat> fixOutputFormats = new HashMap<String, IReportOutputFormat>();
    private static final Map<String, DynamicReportOutputFormat> dynamicOutputFormats = new HashMap<String, DynamicReportOutputFormat>();
    private static final Map<String, IReportType> reportTypes = new HashMap<String, IReportType>();
    private static final Map<String, IFrameDocGenerator> map_reportTypeID_docGenerator = new HashMap<String, IFrameDocGenerator>();

    static {
        DocGeneratorManager.readDocGeneratorExtensionPoint();
    }

    public void construct(IFrameProjectAgent projectAgent_) {
        this.projectAgent = projectAgent_;
    }

    private static void readDocGeneratorExtensionPoint() {
        IExtension[] extensions;
        String extensionPointID = "documentGenerators";
        String attributeName = "Class";
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.arcway.cockpit.frame.client", extensionPointID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = currentExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                try {
                    IFrameDocGenerator generator = (IFrameDocGenerator)currentConfigElement.createExecutableExtension(attributeName);
                    generator.init();
                    docGenerators.add(generator);
                    for (IReportType reportType : generator.getSupportedReportTypes()) {
                        reportTypes.put(reportType.getID(), reportType);
                        map_reportTypeID_docGenerator.put(reportType.getID(), generator);
                    }
                    for (IReportTemplateType reportTemplateType : generator.getRelevantReportTemplateTypes()) {
                        reportTemplateTypes.put(reportTemplateType.getID(), reportTemplateType);
                    }
                    for (IReportOutputTemplateType reportOutputTemplateType : generator.getRelevantReportOutputTemplateTypes()) {
                        reportOutputTemplateTypes.put(reportOutputTemplateType.getID(), reportOutputTemplateType);
                    }
                    for (IReportOutputFormat outputFormat : generator.getRelevantOutputFormats()) {
                        fixOutputFormats.put(outputFormat.getID(), outputFormat);
                    }
                }
                catch (CoreException e) {
                    logger.warn("Couldn't create a doc generator: " + currentConfigElement.getName(), (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static IReportTemplateType getReportTemplateType(String reportTemplateTypeID) {
        return reportTemplateTypes.get(reportTemplateTypeID);
    }

    public Collection<IReportOutputTemplateType> getAllReportOutputTemplateTypes() {
        return reportOutputTemplateTypes.values();
    }

    public IReportOutputTemplateType getReportOutputTemplateType(String reportOutputTemplateTypeID) {
        return reportOutputTemplateTypes.get(reportOutputTemplateTypeID);
    }

    public Collection<IReportOutputFormat> getAllReportOutputFormats() {
        HashSet<IReportOutputFormat> outputFormats = new HashSet<IReportOutputFormat>();
        outputFormats.addAll(fixOutputFormats.values());
        outputFormats.addAll(dynamicOutputFormats.values());
        return outputFormats;
    }

    public Collection<IReportOutputFormat> getFixReportOutputFormats() {
        return fixOutputFormats.values();
    }

    public static IReportOutputFormat getReportOutputFormat(String reportOutputFormatID) {
        if (fixOutputFormats.containsKey(reportOutputFormatID)) {
            return fixOutputFormats.get(reportOutputFormatID);
        }
        if (dynamicOutputFormats.containsKey(reportOutputFormatID)) {
            return dynamicOutputFormats.get(reportOutputFormatID);
        }
        return null;
    }

    public static Collection<IReportType> getAllReportTypes() {
        return reportTypes.values();
    }

    public static IReportType getReportType(String reportTypeID) {
        return reportTypes.get(reportTypeID);
    }

    public IFrameDocGenerator getReportGeneratorForReportType(String reportTypeID) {
        return map_reportTypeID_docGenerator.get(reportTypeID);
    }

    public static Collection<IReportType> getPossibleReportTypes(IReportTemplate reportTemplate, boolean exact) {
        File reportTemplateFile = reportTemplate.getReportFile();
        Collection<IReportType> reportTypes_ = DocGeneratorManager.getPossibleReportTypes(reportTemplateFile, exact);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)reportTemplateFile);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.warn("Could not delete report template file.", (Throwable)e);
        }
        return reportTypes_;
    }

    public static Collection<IReportType> getPossibleReportTypes(File reportTemplateFile, boolean exact) {
        ArrayList<IReportType> possibleReportTypes = new ArrayList<IReportType>(DocGeneratorManager.getAllReportTypes().size());
        HashMap<String, Boolean> map_reportTemplateTypeID_templateIsOfThisType = new HashMap<String, Boolean>();
        block0: for (IReportType reportType : DocGeneratorManager.getAllReportTypes()) {
            for (String reportTemplateTypeID : reportType.getApplicableReportTemplateTypes()) {
                Boolean templateIsOfThisType = (Boolean)map_reportTemplateTypeID_templateIsOfThisType.get(reportTemplateTypeID);
                if (templateIsOfThisType == null) {
                    IReportTemplateType reportTemplateType = DocGeneratorManager.getReportTemplateType(reportTemplateTypeID);
                    IFileValidator fileValidator = exact ? reportTemplateType.getThoroughFileValidator() : reportTemplateType.getHighPerformanceFileValidator();
                    templateIsOfThisType = fileValidator.isValid(reportTemplateFile);
                    map_reportTemplateTypeID_templateIsOfThisType.put(reportTemplateTypeID, templateIsOfThisType);
                }
                if (!templateIsOfThisType.booleanValue()) continue;
                possibleReportTypes.add(reportType);
                continue block0;
            }
        }
        Collections.sort(possibleReportTypes, new Comparator<IReportType>(){

            @Override
            public int compare(IReportType o1, IReportType o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        return possibleReportTypes;
    }

    public Collection<? extends IReportTemplate> getBuiltInReportTemplates(Locale locale) {
        ArrayList<? extends IReportTemplate> addionalTemplates = new ArrayList<IReportTemplate>();
        for (IFrameDocGenerator docGenerator : docGenerators) {
            addionalTemplates.addAll(docGenerator.getBuiltInReportTemplates(locale));
        }
        return addionalTemplates;
    }

    public Collection<? extends IReportOutputTemplate> getBuiltInOutputTemplates(String reportOutputTemplateTypeID, Locale locale) {
        ArrayList<? extends IReportOutputTemplate> outputTemplates = new ArrayList<IReportOutputTemplate>();
        for (IFrameDocGenerator docGenerator : docGenerators) {
            outputTemplates.addAll(docGenerator.getBuiltInOutputTemplates(reportOutputTemplateTypeID, locale));
        }
        return outputTemplates;
    }

    public Collection<? extends IReportOutputTemplate> getAvailableOutputTemplates(String reportOutputTemplateTypeID, IReportTemplateFolder reportTemplateFolder, Locale locale) {
        IReportOutputTemplateType outputTemplateType = this.getReportOutputTemplateType(reportOutputTemplateTypeID);
        if (outputTemplateType == null) {
            return Collections.emptySet();
        }
        ArrayList<IReportOutputTemplate> outputTemplates = new ArrayList<IReportOutputTemplate>();
        if (reportTemplateFolder != null) {
            this.addReportOutputTemplatesOfFolder(reportOutputTemplateTypeID, reportTemplateFolder, outputTemplates);
        }
        if (locale != null) {
            outputTemplates.addAll(this.getBuiltInOutputTemplates(reportOutputTemplateTypeID, locale));
        }
        return outputTemplates;
    }

    private void addReportOutputTemplatesOfFolder(String reportOutputTemplateTypeID, IReportTemplateFolder folder, Collection<IReportOutputTemplate> outputTemplates) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(folder.getTypeID());
        for (IAttributeOwner iAttributeOwner : dataManager.getChildren((IAttributeOwner)folder)) {
            IReportOutputtemplateRW outputTemplate;
            if (!(iAttributeOwner instanceof IReportOutputtemplateRW) || !(outputTemplate = (IReportOutputtemplateRW)iAttributeOwner).getReportOutputTemplateTypeID().equals(reportOutputTemplateTypeID) || outputTemplates.contains(outputTemplate)) continue;
            outputTemplates.add(outputTemplate);
        }
        IAttributeOwner iAttributeOwner = dataManager.getParent((IAttributeOwner)folder);
        if (iAttributeOwner instanceof IReportTemplateFolderRW) {
            this.addReportOutputTemplatesOfFolder(reportOutputTemplateTypeID, (IReportTemplateFolderRW)iAttributeOwner, outputTemplates);
        }
    }

    public static void registerReportOutputFormat(DynamicReportOutputFormat reportOutputFormat) {
        dynamicOutputFormats.put(reportOutputFormat.getID(), reportOutputFormat);
    }

    @Override
    public String getLocalizedManagerName() {
        return "Documentation Generation Manager";
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public void discardLocalModifications() {
    }

    @Override
    public boolean hasLocalModifications() {
        return false;
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        return null;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return null;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return null;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        return null;
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        return null;
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        return null;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        return null;
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        return false;
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return false;
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }
}

