/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange;

import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class ProjectFileWriter {
    private static final ILogger LOGGER = Logger.getLogger(ProjectFileWriter.class);
    private static final String EXPORT_TEMP_DIR_NAME = "cockpit_export_tmp";
    private static final int CURRENT_PROJECTFILE_VERSION = 7;

    public static void createProjectFile(IProjectDataProvider projectDataProvider, File saveFile) throws IOException, JvmExternalResourceInteractionException {
        SessionTempDirectoryManager.SessionTempDirectory rootFolderOfTemporaryProjectFileStructure = SessionTempDirectoryManager.createSessionTempSubDirectory((String)EXPORT_TEMP_DIR_NAME);
        ProjectFileWriter.writeVersionsFile((File)rootFolderOfTemporaryProjectFileStructure);
        EOList<EOList<? extends EncodableObjectBase>> mainData = projectDataProvider.getMainData();
        Collection<EOFileMetaInformation> fileMetaInformation = ProjectFileWriter.writeFileArchive((File)rootFolderOfTemporaryProjectFileStructure, projectDataProvider);
        if (fileMetaInformation != null) {
            EOList fileMetaInformation_asEOList = new EOList(fileMetaInformation, "fileMetaInformation");
            mainData.add((EncodableObjectBase)fileMetaInformation_asEOList);
        }
        ProjectFileWriter.writeMainData((File)rootFolderOfTemporaryProjectFileStructure, mainData);
        ProjectFileWriter.createProjectFileFromAndDeleteTemporaryStructure((File)rootFolderOfTemporaryProjectFileStructure, saveFile);
    }

    public static void writeVersionsFile(File newProjectFileStructure) throws IOException {
        File versionFile = new File(newProjectFileStructure, "version");
        HashMap<String, Integer> versionsMap = new HashMap<String, Integer>();
        versionsMap.put("project-file-version", 7);
        EOVersionFileContent versions = new EOVersionFileContent("cockpit.project-file", versionsMap);
        versions.writeToFile(versionFile);
    }

    public static void writeMainData(File newProjectFileStructure, EOList<EOList<? extends EncodableObjectBase>> mainData) throws IOException {
        File mainDataFile = new File(newProjectFileStructure, "maindata");
        mainData.writeToFile(mainDataFile);
    }

    public static Collection<EOFileMetaInformation> writeFileArchive(File newProjectFileStructure, IProjectDataProvider projectDataProvider) throws JvmExternalResourceInteractionException {
        File fileArchiveDirectory = new File(newProjectFileStructure, "files");
        FileHelper.ensureDirectoryExistance((File)fileArchiveDirectory);
        return projectDataProvider.doExportFiles(fileArchiveDirectory);
    }

    public static void createProjectFileFromAndDeleteTemporaryStructure(File newProjectFileStructure, File saveFile) throws IOException, JvmExternalResourceInteractionException {
        if (saveFile.exists()) {
            FileHelper.deleteExistingFileOrDirectory((File)saveFile);
        }
        Zip.createZipFile((File)newProjectFileStructure, (File)saveFile);
        try {
            FileHelper.deleteExistingFileOrDirectory((File)newProjectFileStructure);
        }
        catch (JvmExternalResourceInteractionException e) {
            LOGGER.debug("Error while deleting obsolete temporary ExportDirectory.", (Throwable)e);
        }
    }

    public static interface IProjectDataProvider {
        public EOList<EOList<? extends EncodableObjectBase>> getMainData();

        public Collection<EOFileMetaInformation> doExportFiles(File var1) throws JvmExternalResourceInteractionException;
    }
}

