/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.PlanWithOccurrences;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OccurrenceList
implements Collection<EOUniqueElementOccurrence> {
    private static final ILogger logger = Logger.getLogger(OccurrenceList.class);
    private final Map<String, PlanWithOccurrences> plansWithOccurrences;
    private final UniqueElementMgr uniqueElementManager;

    protected OccurrenceList(UniqueElementMgr uniqueElementManager) {
        this.uniqueElementManager = uniqueElementManager;
        this.plansWithOccurrences = new HashMap<String, PlanWithOccurrences>();
    }

    protected OccurrenceList(OccurrenceList list, UniqueElementMgr uniqueElementManager) {
        assert (uniqueElementManager == list.uniqueElementManager);
        this.uniqueElementManager = uniqueElementManager;
        this.plansWithOccurrences = new HashMap<String, PlanWithOccurrences>(list.plansWithOccurrences.size() * 2);
        for (Map.Entry<String, PlanWithOccurrences> entry : list.plansWithOccurrences.entrySet()) {
            this.plansWithOccurrences.put(entry.getKey(), new PlanWithOccurrences(entry.getValue()));
        }
    }

    public boolean contains(String planUID) {
        return this.plansWithOccurrences.containsKey(planUID);
    }

    public boolean contains(String planUID, String planElementUID) {
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.contains(planElementUID);
        }
        return false;
    }

    public EOUniqueElementOccurrence get(String planUID, String planElementUID) {
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getOccurrence(planElementUID);
        }
        return null;
    }

    public boolean remove(String planUID, String planElementUID) {
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo != null) {
            EOUniqueElementOccurrence removedOccurence = pwo.removeOccurrence(planElementUID);
            if (pwo.isEmpty()) {
                this.plansWithOccurrences.remove(planUID);
            }
            return removedOccurence != null;
        }
        return false;
    }

    public Collection<IUniqueElement> getUniqueElementsOfPlan(String planUID) {
        Collection<IUniqueElement> uniqueElements;
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo != null) {
            Collection<EOUniqueElementOccurrence> allOccurences = pwo.getAllOccurrences();
            int allOccurencesSize = allOccurences.size();
            if (allOccurencesSize < 20) {
                uniqueElements = new ArrayList(allOccurencesSize);
                for (EOUniqueElementOccurrence occurrence : allOccurences) {
                    IUniqueElement ue = this.uniqueElementManager.getUniqueElement(occurrence.getElementUID());
                    if (ue == null) {
                        assert (false);
                        logger.error("Occurence for non existing Unique element detected");
                        continue;
                    }
                    if (uniqueElements.contains(ue)) continue;
                    uniqueElements.add(ue);
                }
            } else {
                HashMap<String, IUniqueElement> uniqueElementsMap = new HashMap<String, IUniqueElement>(2 * allOccurencesSize);
                uniqueElements = uniqueElementsMap.values();
                for (EOUniqueElementOccurrence occurrence : allOccurences) {
                    String elementUID = occurrence.getElementUID();
                    if (uniqueElementsMap.containsKey(elementUID)) continue;
                    IUniqueElement ue = this.uniqueElementManager.getUniqueElement(elementUID);
                    if (ue == null) {
                        assert (false);
                        logger.error("Occurence for non existing Unique element detected");
                        continue;
                    }
                    uniqueElementsMap.put(elementUID, ue);
                }
            }
        } else {
            uniqueElements = new ArrayList<IUniqueElement>();
        }
        return uniqueElements;
    }

    public Collection<String> getPlans() {
        return this.plansWithOccurrences.keySet();
    }

    public Collection<EOUniqueElementOccurrence> getUniqueElementOccurrencesOnPlan(String planUID) {
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo != null) {
            return pwo.getAllOccurrences();
        }
        return Collections.emptyList();
    }

    @Override
    public int size() {
        int size = 0;
        for (PlanWithOccurrences pwo : this.plansWithOccurrences.values()) {
            size += pwo.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.plansWithOccurrences.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        EOUniqueElementOccurrence uo;
        PlanWithOccurrences pwo;
        if (o instanceof EOUniqueElementOccurrence && (pwo = this.plansWithOccurrences.get((uo = (EOUniqueElementOccurrence)o).getPlanUID())) != null) {
            return pwo.contains(uo.getPlanElementUID());
        }
        return false;
    }

    @Override
    public Iterator<EOUniqueElementOccurrence> iterator() {
        return new OccurrenceListIterator();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] resultArray = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        int number = 0;
        for (PlanWithOccurrences pwo : this.plansWithOccurrences.values()) {
            Collection<EOUniqueElementOccurrence> occurrencesOfPlan = pwo.getAllOccurrences();
            for (EOUniqueElementOccurrence eoUniqueElementOccurrence : occurrencesOfPlan) {
                resultArray[number++] = eoUniqueElementOccurrence;
            }
        }
        if (resultArray.length > size) {
            resultArray[size + 1] = null;
        }
        return resultArray;
    }

    @Override
    public boolean add(EOUniqueElementOccurrence occurrence) {
        String planUID = occurrence.getPlanUID();
        PlanWithOccurrences pwo = this.plansWithOccurrences.get(planUID);
        if (pwo == null) {
            pwo = new PlanWithOccurrences(planUID);
            this.plansWithOccurrences.put(planUID, pwo);
        }
        pwo.addOccurrence(occurrence);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof EOUniqueElementOccurrence) {
            EOUniqueElementOccurrence occurrence = (EOUniqueElementOccurrence)o;
            return this.remove(occurrence.getPlanUID(), occurrence.getPlanElementUID());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        for (Object o : elements) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends EOUniqueElementOccurrence> elements) {
        for (EOUniqueElementOccurrence eOUniqueElementOccurrence : elements) {
            this.add(eOUniqueElementOccurrence);
        }
        return !elements.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        boolean collectionChanged = false;
        for (Object element : elements) {
            boolean bl = collectionChanged = this.remove(element) || collectionChanged;
        }
        return collectionChanged;
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        boolean changed = false;
        Iterator<EOUniqueElementOccurrence> i = this.iterator();
        while (i.hasNext()) {
            EOUniqueElementOccurrence occurence = i.next();
            if (elements.contains(occurence)) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.plansWithOccurrences.clear();
    }

    private class OccurrenceListIterator
    implements Iterator<EOUniqueElementOccurrence> {
        private final Iterator<PlanWithOccurrences> plansIterator;
        private Iterator<EOUniqueElementOccurrence> occurrencesIterator;
        private PlanWithOccurrences currentPlan;

        private OccurrenceListIterator() {
            this.plansIterator = OccurrenceList.this.plansWithOccurrences.values().iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNextOccurrence;
            if (this.occurrencesIterator != null && (hasNextOccurrence = this.occurrencesIterator.hasNext())) {
                return true;
            }
            return this.plansIterator.hasNext();
        }

        @Override
        public EOUniqueElementOccurrence next() {
            if (this.occurrencesIterator == null || !this.occurrencesIterator.hasNext()) {
                this.currentPlan = this.plansIterator.next();
                this.occurrencesIterator = this.currentPlan.getAllOccurrences().iterator();
            }
            return this.occurrencesIterator.next();
        }

        @Override
        public void remove() {
            this.occurrencesIterator.remove();
            if (this.currentPlan.isEmpty()) {
                this.plansIterator.remove();
            }
        }
    }
}

